/**
 * @(#) CargoStorageChangeTypeEnum.java 1.0 2018-09-03
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * 货品库存变更日志类型
 *
 * @author 魄罗
 * @since 2.0.0
 */
public enum StorageChangeTypeEnum {
    ORDER_CHANGE("ORDER_CHANGE", "订单变更"),
    STORAGE_OUT("STORAGE_OUT", "出库变更"),
    STORAGE_IN("STORAGE_IN", "入库变更")
    ;

    /**
     * 库存变更类型
     */
    private String type;
    /**
     * 库存变更类型名称
     */
    private String typeName;

    StorageChangeTypeEnum(String type, String typeName){
        this.type = type;
        this.typeName = typeName;
    }

    public static String getStatusName(Integer type){
        if (type == null){
            return null;
        }
        for (StorageChangeTypeEnum storageChangeTypeEnum : StorageChangeTypeEnum.values()){
            if (type.equals(storageChangeTypeEnum.getType())){
                return storageChangeTypeEnum.getTypeName();
            }
        }
        return null;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
}
