/**
 * @(#)DrEnum.java 1.0 2018年8月31日
 *
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api.constants;

import org.apache.commons.lang3.StringUtils;

/**
 * 库存检查类型
 * 
 * @author 水镜
 * @since 2.0.0
 */
public enum StorageCheckConfigEnum {

	GENERAL_CHECK("GENERAL", "总仓检查"), 
	SEPARATE_CHECK("SEPARATE", "分仓检查"),
	WHOLE_CHECK("WHOLE", "全局检查");

	private String code;
	private String text;

	StorageCheckConfigEnum(String code, String text) {
		this.code = code;
		this.text = text;
	}

	public String getCode() {
		return code;
	}

	public String getText() {
		return text;
	}

	/**
	 * 根据code获取text
	 * 
	 * @param code
	 *            状态编码
	 * @return 状态说明
	 */
	public static String getText(String code) {
		if (StringUtils.isBlank(code)) {
			return null;
		}
		for (StorageCheckConfigEnum drEnum : StorageCheckConfigEnum.values()) {
			if (code.equals(drEnum.getCode())) {
				return drEnum.getText();
			}
		}
		return null;
	}

}
