/*
 * @(#)StorageOrderTypeEnum.java 1.0 2018-08-30
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * 出入库类型枚举类
 *
 *
 * @author 书生
 * @since 2.0.0
 */
public enum StorageOrderTypeEnum {

    ONLINE_SALES(1, "线上销售"),
    OFFLINE_SALES(2, "线下销售"),
    ORDER_SALE(3, "订货销售"),
    DEPLOYMENT(4, "调配"),
    INVENTORY_LOSS(5, "盘亏"),
    TRANSFER_WAREHOUSE_OUT(6, "移库出库"),
    MANAGEMENT(7, "处置"),
    ONLINE_SALES_RETURN(8, "线上销售退货"),
    OFFLINE_SALES_RETURN(9, "线下销售退货"),
    ORDER_SALES_RETURN(10, "订货销售退货"),
    INVENTORY_SURPLUS(11, "盘盈"),
    TRANSFER_STORAGE(12, "移库入库"),


    TRANSFER(15, "调拨单"),
    UNDEFINED(0, "未定义的类型");

    private Integer code;

    private String desc;

    StorageOrderTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code) {
        return getTypeByCode(code).getDesc();
    }

    public static StorageOrderTypeEnum getTypeByCode(Integer code) {
        if (null != code) {
            for (StorageOrderTypeEnum s : StorageOrderTypeEnum.values()) {
                if (s.getCode().equals(code)) {
                    return s;
                }
            }
        }

        return UNDEFINED;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}
