/**
 * @(#) CargoStorageChangeStatusEnum.java 1.0 2018-09-04
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.constants;

import org.apache.commons.lang3.StringUtils;

/**
 * 出库单消息状态
 *
 * @author 简树
 * @since 2.0.0
 */
public enum StorageStatusMessageEnum {
    CREATE_OUT("create_out", "已出库"),
    WAIT_OUT("wait_out", "待出库");

    private String status;

    private String statusName;

    StorageStatusMessageEnum(String status, String statusName){
        this.status = status;
        this.statusName = statusName;
    }

    public static String getStatusName(String status){
        if (StringUtils.isBlank(status)){
            return null;
        }
        for (StorageStatusMessageEnum storageChangeStatusEnum : StorageStatusMessageEnum.values()){
            if (status.equals(storageChangeStatusEnum.getStatus())){
                return storageChangeStatusEnum.getStatusName();
            }
        }
        return null;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatusName() {
        return statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }
}
