/**
 * @(#) DeliveryStatusEnums.java 1.0 2018-08-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * 描述
 *
 * @author 魄罗
 * @since 1.0.0
 */
public enum TradeOrderStatusEnum {
    WAIT_DELIVERY("wait_delivery", "等待发货"),
    CANCEL_DELIVERY("cancel_delivery", "取消发货"),
    SUCCESS_DELIVERY("success_delivery", "成功发货"),
    ;

    private String status;
    private String statusName;

    TradeOrderStatusEnum(String status, String statusName){
        this.status = status;
        this.statusName = statusName;
    }

    public static String getStatusName(String status){
        if (status == null){
            return null;
        }
        for (TradeOrderStatusEnum deliveryOrderStatusEnum : TradeOrderStatusEnum.values()){
            if (status.equals(deliveryOrderStatusEnum.getStatus())){
                return deliveryOrderStatusEnum.getStatusName();
            }
        }
        return null;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatusName() {
        return statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }
}
