/**
 * @(#)TransferOrderStatusEnum.java 1.0 2018年8月31日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * 调拨单状态
 */
public enum TransferOrderStatusEnum {
    WAIT_COMMIT(1, "待提交"),
    WAIT_AUDIT(2, "待审核"),
    AUDIT_NO_PASS(3, "审核不通过"),
    WAIT_EXECUTE(4, "待执行"),
    IN_EXECUTE(5, "执行中"),
    FINISH(6, "已完成"),
    CANCEL(7, "已取消")
    ;

    private final Integer status;
    private final String name;

    TransferOrderStatusEnum(Integer status, String name) {
        this.status = status;
        this.name = name;
    }

    /**
     * 根据状态编码获取名称
     *
     * @param status 状态编码
     * @return 状态说明
     */
    public static String nameOf(Integer status) {
        if (status == null) {
            return null;
        }
        for (TransferOrderStatusEnum item : TransferOrderStatusEnum.values()) {
            if (item.getStatus().equals(status)) {
                return item.getName();
            }
        }
        return null;
    }

    public Integer getStatus() {
        return status;
    }

    public String getName() {
        return name;
    }

}
