/**
 * @(#)TransferOrderStatusEnum.java 1.0 2018年8月31日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * 调拨单类型
 */
public enum TransferOrderTypeEnum {
    PHYSICAL(1, "物理调拨单"),
    VIRTUAL(2, "虚拟调拨单"),
    ;

    private final Integer type;
    private final String name;

    TransferOrderTypeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    /**
     * 根据类型编码获取名称
     *
     * @param type 类型编码
     * @return 类型说明
     */
    public static String nameOf(Integer type) {
        if (type == null) {
            return null;
        }
        for (TransferOrderTypeEnum item : TransferOrderTypeEnum.values()) {
            if (item.getType().equals(type)) {
                return item.getName();
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

}
