/**
 * @(#) CargoStorageDto.java 1.0 2018-09-07
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 货品库存Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "CargoStorageDto", description = "货品库存Dto")
public class CargoStorageDto extends BaseVo {

    @ApiModelProperty(name = "ID", value = "主键")
    private Long id;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    /**
     * 变更来源
     */
    @ApiModelProperty(name = "changeType", value = "变更来源")
    private String changeType;
    /**
     * 交易订单号/出入库单号
     */
    @ApiModelProperty(name = "orderNo", value = "交易订单号/出入库单号")
    private String orderNo;
    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     * 仓位ID
     */
    @ApiModelProperty(name = "positionId", value = "仓位ID")
    private Long positionId;
    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
     * 状态
     */
    @ApiModelProperty(name = "cargoCode", value = "商品编码")
    private String cargoCode;
    /**
     * 货品货号
     */
    @ApiModelProperty(name = "artNo",value = "货品货号")
    private String artNo;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;
    /**
     * 总库存
     */
    @ApiModelProperty(name = "balance", value = "总库存")
    private BigDecimal balance;
    /**
     * 可用数量
     */
    @ApiModelProperty(name = "available", value = "可用数量")
    private BigDecimal available;
    /**
     * 预占数量
     */
    @ApiModelProperty(name = "appending", value = "预占数量")
    private BigDecimal appending;
    /**
     * 已支配
     */
    @ApiModelProperty(name = "allocate", value = "已支配")
    private BigDecimal allocate;
    /**
     * 在途数量
     */
    @ApiModelProperty(name = "intransit", value = "在途数量")
    private BigDecimal intransit;
    /**
     * 预售
     */
    @ApiModelProperty(name = "presell", value = "预售")
    private BigDecimal presell;
    /**
     * 活动库存
     */
    @ApiModelProperty(name = "activity", value = "活动库存")
    private BigDecimal activity;
    /**
     * 残次品
     */
    @ApiModelProperty(name = "imperfections", value = "残次品")
    private Long imperfections;
    /**
     * 赔付品
     */
    @ApiModelProperty(name = "indemnity", value = "赔付品")
    private Long indemnity;
    /**
     * 状态
     */
    @ApiModelProperty(name = "status", value = "状态")
    private String status;
    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;
    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;

    /**
     * 实例ID
     */
    @ApiModelProperty(name = "batch", value = "批次号")
    private String batch;

    @ApiModelProperty(name = "expire_time")
    private Date expireTime;

    /**
     * 生产日期
     */
    @ApiModelProperty(name = "produce_time")
    private Date produceTime;

    public BigDecimal getAvailable() {
        return available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public Long getPositionId() {
        return positionId;
    }

    public void setPositionId(Long positionId) {
        this.positionId = positionId;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getAppending() {
        return appending;
    }

    public void setAppending(BigDecimal appending) {
        this.appending = appending;
    }

    public BigDecimal getAllocate() {
        return allocate;
    }

    public void setAllocate(BigDecimal allocate) {
        this.allocate = allocate;
    }

    public BigDecimal getIntransit() {
        return intransit;
    }

    public void setIntransit(BigDecimal intransit) {
        this.intransit = intransit;
    }

    public BigDecimal getPresell() {
        return presell;
    }

    public void setPresell(BigDecimal presell) {
        this.presell = presell;
    }

    public BigDecimal getActivity() {
        return activity;
    }

    public void setActivity(BigDecimal activity) {
        this.activity = activity;
    }

    public Long getImperfections() {
        return imperfections;
    }

    public void setImperfections(Long imperfections) {
        this.imperfections = imperfections;
    }

    public Long getIndemnity() {
        return indemnity;
    }

    public void setIndemnity(Long indemnity) {
        this.indemnity = indemnity;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }
}
