package com.dtyunxi.yundt.cube.center.inventory.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 货品库存共享页面dto
 *
 * @ClassName StorageShareDto
 * @Author chunjiu
 * @Date 2020/9/12 14:44
 */
@ApiModel(value = "CargoStorageShareDto", description = "货品库存共享页面dto")
public class CargoStorageShareDto {

    /**
     * 仓库编码
     */
    @NotNull(message = "仓库编码不能为空")
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    /**
     * 货品名称
     */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    /**
     * 所属客户
     */
    @ApiModelProperty(name = "customerNo", value = "所属客户")
    private String customerNo;

    /**
     * 货号
     */
    @ApiModelProperty(name = "artNo", value = "货号")
    private String artNo;

    /**
     * 货品条码
     */
    @ApiModelProperty(name = "barCode", value = "货品条码")
    private String barCode;

    /**
     * 共享仓库设置
     */
    @NotNull(message = "共享仓库设置不能为空")
    @ApiModelProperty(name = "shareWarehouseArr", value = "共享仓库设置")
    private List<CargoWarehouseShareDto> cargoWarehouseShareDtos;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public List<CargoWarehouseShareDto> getCargoWarehouseShareDtos() {
        return cargoWarehouseShareDtos;
    }

    public void setCargoWarehouseShareDtos(List<CargoWarehouseShareDto> cargoWarehouseShareDtos) {
        this.cargoWarehouseShareDtos = cargoWarehouseShareDtos;
    }
}
