package com.dtyunxi.yundt.cube.center.inventory.api.dto;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @author ganguo.ggw@dtyunxi.com
 * @version 1.0.0
 * @Description TODO
 * @company 云徙科技[www.dtyunxi.com]
 * @createTime 2021年08月30日 14:16:00
 */
public class DeliveryItemDto extends BaseVo {

    /**
     * 交易流水号
     */
    @ApiModelProperty(name = "trade_no", value = "交易流水号 （必填）")
    private String tradeNo;

    /**
     * 数量
     */
    @ApiModelProperty(name = "item_num", value = "数量  (必填)")
    private Integer itemNum;

    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargo_serial", value = "货品编码 (必填)")
    private String cargoSerial;

    /**
     * skuId
     */
    @ApiModelProperty(name = "sku_serial", value = "skuId")
    private String skuSerial;

    /**
     * 商品名称
     */
    @ApiModelProperty(name = "item_name", value = "商品名称")
    private String itemName;

    /**
     * 商品编号（款号） (必填)
     */
    @ApiModelProperty(name = "item_code", value = "商品编号（款号） (必填)")
    private String itemCode;

    /**
     * 订单商品明细id
     */
    @ApiModelProperty(name = "tr_order_item_no", value = "订单商品明细id (必填)")
    private String trOrderItemNo;

    /**
     * 发货类型
     * 普通发送,发补发, 换货重发
     */
    @ApiModelProperty(name = "delivery_type", value = "发货类型: NORMAL 普通发送, MERGE 合并发货")
    private String deliveryType = "NORMAL";

    /**
     * 商品价格
     */
    @ApiModelProperty(name = "item_price", value = " 商品价格")
    private BigDecimal itemPrice;

    /**
     * 商品图片
     */
    @ApiModelProperty(name = "item_img_path", value = "商品图片")
    private String itemImgPath;

    /**
     * sku编码 (必填)
     */
    @ApiModelProperty(name = "sku_code", value = "sku编码 (必填)")
    private String skuCode;

    /**
     * sku规格描述
     */
    @ApiModelProperty(name = "sku_desc", value = " sku规格描述")
    private String skuDesc;

    /**
     * 发货小类
     * 比如补发 ,可以是漏发的补发,  损坏的补发,
     */
    @ApiModelProperty(name = "delivery_sub_type", value = "发货小类: NORMAL 普通发送")
    private String deliverySubType = "NORMAL";


    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getTrOrderItemNo() {
        return trOrderItemNo;
    }

    public void setTrOrderItemNo(String trOrderItemNo) {
        this.trOrderItemNo = trOrderItemNo;
    }

    public String getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(String deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getDeliverySubType() {
        return deliverySubType;
    }

    public void setDeliverySubType(String deliverySubType) {
        this.deliverySubType = deliverySubType;
    }

    public Integer getItemNum() {
        return itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }

    public String getCargoSerial() {
        return cargoSerial;
    }

    public void setCargoSerial(String cargoSerial) {
        this.cargoSerial = cargoSerial;
    }

    public String getSkuSerial() {
        return skuSerial;
    }

    public void setSkuSerial(String skuSerial) {
        this.skuSerial = skuSerial;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    public String getItemImgPath() {
        return itemImgPath;
    }

    public void setItemImgPath(String itemImgPath) {
        this.itemImgPath = itemImgPath;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuDesc() {
        return skuDesc;
    }

    public void setSkuDesc(String skuDesc) {
        this.skuDesc = skuDesc;
    }
}
