/**
 * @(#) DeliveryOrderDetailDto.java 1.0 2018-08-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 交易单明细Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "DeliveryOrderDetailDto", description = "发货单明细Dto")
public class DeliveryOrderDetailDto extends BaseVo {

    /**
     * 发货单ID
     */
    @ApiModelProperty(name="deliveryOrderId",value = "发货单ID")
    private Long deliveryOrderId;
    /**
     * 发货单编号
     */
    @ApiModelProperty(name="deliveryOrderNo",value = "发货单编号")
    private String deliveryOrderNo;
    /**
     * 货品ID
     */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /**
     * 货品编码
     */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /**
     * 货品数量
     */
    @ApiModelProperty(name="num",value = "货品数量")
    private Long num;
    /**
     * 仓库ID
     */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /**
     * 仓位ID
     */
    @ApiModelProperty(name="positionId",value = "仓位ID")
    private Long positionId;
    /**
     * 应用实例ID
     */
    @ApiModelProperty(name="appInstanceId",value = "应用实例ID")
    private Long appInstanceId;

    public Long getDeliveryOrderId() {
        return deliveryOrderId;
    }

    public void setDeliveryOrderId(Long deliveryOrderId) {
        this.deliveryOrderId = deliveryOrderId;
    }

    public String getDeliveryOrderNo() {
        return deliveryOrderNo;
    }

    public void setDeliveryOrderNo(String deliveryOrderNo) {
        this.deliveryOrderNo = deliveryOrderNo;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public Long getNum() {
        return num;
    }

    public void setNum(Long num) {
        this.num = num;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public Long getPositionId() {
        return positionId;
    }

    public void setPositionId(Long positionId) {
        this.positionId = positionId;
    }

    public Long getAppInstanceId() {
        return appInstanceId;
    }

    public void setAppInstanceId(Long appInstanceId) {
        this.appInstanceId = appInstanceId;
    }
}
