package com.dtyunxi.yundt.cube.center.inventory.api.dto;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author ganguo.ggw@dtyunxi.com
 * @version 1.0.0
 * @Description TODO
 * @company 云徙科技[www.dtyunxi.com]
 * @createTime 2021年08月30日 14:00:00
 */
public class OrderDeliveryDto extends BaseVo {

    /**
     * 发货单据号
     */
    @ApiModelProperty(name = "delivery_no", value = "单据号,作为发货单的唯一性校验码 (必填)")
    @NotEmpty(message = "单据号不能为空")
    private String deliveryNo;

    /**
     * 交易流水号
     */
    @ApiModelProperty(name = "trade_no", value = "交易流水号 (必填)")
    @NotEmpty(message = "交易流水号不能为空")
    private String tradeNo;

    /**
     * 父发货单号
     */
    @ApiModelProperty(name = "parent_delivery_no", value = "父发货单号 (选填)")
    private String parentDeliveryNo;

    /**
     * 是否已拆单，0-未拆单，1-已拆单  (选填)
     */
    @ApiModelProperty(name = "split_flag", value = "是否已拆单，0-未拆单，1-已拆单  (必填)")
    @NotNull(message = "是否已拆单不能为空")
    private Integer splitFlag;

    /**
     * 配送方式：（express 快递 pickup 自提  intra-city 同城配送 ） 默认是 express
     */
    @ApiModelProperty(name = "shipping_type", value = "配送方式：（express 快递 pickup 自提  intra-city 同城配送 ） 默认是 express")
    private String shippingType;

    /**
     * 发货单状态 :TO_ROUTE:待路由, TO_DO:待处理，TO_ASSIGN:待指派, TO_RECEIVING: 待接单, INIT: 待发货, PARTIAL_DELIVERED: 部分发货, DELIVERED: 已发货, SIGNED: 已签收, CANCELED: 已取消, FINISHED: 已完成，CANCLE：已取消
     */
    @ApiModelProperty(name = "delivery_status", value = "发货单状态 :TO_ROUTE:待路由, TO_DO:待处理，TO_ASSIGN:待指派, TO_RECEIVING: 待接单, INIT: 待发货, PARTIAL_DELIVERED: 部分发货, DELIVERED: 已发货, SIGNED: 已签收, CANCELED: 已取消, FINISHED: 已完成，CANCLE：已取消")
    private String deliveryStatus;

    /**
     * 发货仓库id
     */
    @ApiModelProperty(name = "warehouse_serial", value = "发货仓库id (必填选填)")
    private String warehouseSerial;

    /**
     * 发货仓库编码
     */
    @ApiModelProperty(name = "warehouse_code", value = "发货仓库编码 (选填)")
    private String warehouseCode;

    /**
     * 发货仓库名称   (选填)
     */
    @ApiModelProperty(name = "warehouse_name", value = " 发货仓库名称(选填)")
    private String warehouseName;

    /**
     * 发货门店编码（门店发货时才有值）   (选填)
     */
    @ApiModelProperty(name = "shop_code", value = " 发货门店编码（门店发货时才有值）   (选填)")
    private String shopCode;

    /**
     * 发货单类型：0 路由发货单，1 指派发货单
     */
    @ApiModelProperty(name = "delivery_type", value = "发货单类型：0 路由发货单，1 指派发货单")
    private Integer deliveryType;

    /**
     * 第三方支付平台交易号, 淘系订单传支付宝交易号
     */
    @ApiModelProperty(name = "third_pay_no", value = "第三方支付平台交易号, 淘系订单传支付宝交易号")
    private String thirdPayNo;
    /**
     * 配送人员id  (选填)
     */
    @ApiModelProperty(name = "deliverer_id", value = "配送人员id  (选填)")
    private String delivererId;

    /**
     * 自提类型：订单order  包裹pack 商品 goods
     */
    @ApiModelProperty(name = "pickup_type", value = "自提类型：订单order  包裹pack 商品 goods")
    private String pickupType;

    /**
     * 收货人名称
     */
    @ApiModelProperty(name = "delivery_name", value = "收货人名称")
    private String deliveryName;

    /**
     * 详细地址全称
     */
    @ApiModelProperty(name = "address", value = "详细地址全称")
    private String address;

    /**
     * 收货人手机号
     */
    @ApiModelProperty(name = "delivery_mobile", value = "收货人手机号")
    private String deliveryMobile;

    /**
     * 收货人座机号
     */
    @ApiModelProperty(name = "delivery_phone", value = " 收货人座机号")
    private String deliveryPhone;


    /**
     * 收货人收件人证件类型，1-身份证 2-军官证 3-护照 4-其他
     */
    @ApiModelProperty(name = "identity_type", value = " 收货人收件人证件类型，1-身份证 2-军官证 3-护照 4-其他")
    private Integer identityType;

    /**
     * 收货人收件人证件号码
     */
    @ApiModelProperty(name = "identity_no", value = "收货人收件人证件号码")
    private String identityNo;

    /**
     * 收货人电子邮箱
     */
    @ApiModelProperty(name = "email", value = "收货人电子邮箱")
    private String email;

    /**
     * 国家地区编码
     */
    @ApiModelProperty(name = "country_code", value = "国家地区编码")
    private String countryCode;

    /**
     * 国家地区名称
     */
    @ApiModelProperty(name = "country_name", value = "国家地区名称")
    private String countryName;

    /**
     * 省
     */
    @ApiModelProperty(name = "province_code", value = "省")
    private String provinceCode;

    /**
     * 省名称
     */
    @ApiModelProperty(name = "province_name", value = "")
    private String provinceName;

    /**
     * 市
     */
    @ApiModelProperty(name = "city_code", value = "市")
    private String cityCode;

    /**
     * 市名称
     */
    @ApiModelProperty(name = "city_name", value = "")
    private String cityName;

    /**
     * 区
     */
    @ApiModelProperty(name = "area_code", value = "区")
    private String areaCode;

    /**
     * 区名称
     */
    @ApiModelProperty(name = "area_name", value = "区名称")
    private String areaName;

    /**
     * 街道
     */
    @ApiModelProperty(name = "street_code", value = "街道")
    private String streetCode;

    /**
     * 街道名称
     */
    @ApiModelProperty(name = "street_name", value = " 街道名称")
    private String streetName;

    /**
     * 详细地址
     */
    @ApiModelProperty(name = "detailed", value = "详细地址")
    private String detailed;

    /**
     * 邮编
     */
    @ApiModelProperty(name = "postcode", value = "")
    private String postcode;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "")
    private String remark;

    /**
     * 出库单号
     */
    @ApiModelProperty(name = "delivery_order_code", value = "")
    private String deliveryOrderCode;

    /**
     * 出库单类型，JYCK=一般交易出库单, HHCK=换货出库 单, BFCK=补发出库单，QTCK=其他出库单
     */
    @ApiModelProperty(name = "order_type", value = "")
    private String orderType;

    /**
     * 操作员 (审核员) 编码
     */
    @ApiModelProperty(name = "operator_code", value = "")
    private String operatorCode;

    /**
     * 操作员 (审核员) 名称
     */
    @ApiModelProperty(name = "operator_name", value = "")
    private String operatorName;

    /**
     * 物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、
     * BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、
     * JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)
     */
    @ApiModelProperty(name = "shipping_company_code", value = "物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、\n" +
            "   BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、\n" +
            "  JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)")
    private String shippingCompanyCode;

    /**
     * 物流公司名称
     */
    @ApiModelProperty(name = "shipping_company", value = "物流公司名称")
    private String shippingCompany;

    /**
     * 运单号
     */
    @ApiModelProperty(name = "express_code", value = "运单号")
    private String expressCode;

    /**
     * 投递时延要求，1=工作日,2=节假日,101=当日达,102=次晨达,103=次日达,104=预约达
     */
    @ApiModelProperty(name = "schedule_type", value = "投递时延要求，1=工作日,2=节假日,101=当日达,102=次晨达,103=次日达,104=预约达")
    private Integer scheduleType;

    /**
     * 要求送达日期，要求送达日期，YYYY-MM-DD
     */
    @ApiModelProperty(name = "schedule_day", value = "要求送达日期，要求送达日期，YYYY-MM-DD")
    private String scheduleDay;

    /**
     * 投递时间范围要求(开始时间)，HH:MM:SS
     */
    @ApiModelProperty(name = "schedule_start_time", value = " 投递时间范围要求(开始时间)，HH:MM:SS")
    private String scheduleStartTime;

    /**
     * 投递时间范围要求(结束时间)，HH:MM:SS
     */
    @ApiModelProperty(name = "schedule_end_time", value = "投递时间范围要求(结束时间)，HH:MM:SS")
    private String scheduleEndTime;

    /**
     * 发货服务方式，PTPS（普通配送），LLPS（冷链配送），HBP(环保 配)
     */
    @ApiModelProperty(name = "delivery_method", value = "发货服务方式，PTPS（普通配送），LLPS（冷链配送），HBP(环保 配)")
    private String deliveryMethod;

    /**
     * 业务类型 1-商城，2-全渠道
     */
    @ApiModelProperty(name = "biz_type", value = "业务类型 1-商城，2-全渠道")
    private Integer bizType;

    /**
     * 渠道编码，对应渠道表渠道 ：
     * online  线上
     * offline  线下
     * taobao 淘宝
     * tmall 天猫
     * alibaba 阿里巴巴
     * jd 京东
     * pdd 拼多多
     * douyin  抖音
     * kuaishou 快手
     * meituan 每天
     * suning
     * youzan有赞
     */
    @ApiModelProperty(name = "channel", value = "渠道编码，对应渠道表渠道 ：\n" +
            "     * online  线上\n" +
            "     * offline  线下\n" +
            "     * taobao 淘宝\n" +
            "     * tmall 天猫\n" +
            "     * alibaba 阿里巴巴\n" +
            "     * jd 京东\n" +
            "     * pdd 拼多多\n" +
            "     * douyin  抖音\n" +
            "     * kuaishou 快手\n" +
            "     * meituan 每天\n" +
            "     * suning\n" +
            "     * youzan有赞")
    private String channel;

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getDeliveryNo() {
        return deliveryNo;
    }

    public void setDeliveryNo(String deliveryNo) {
        this.deliveryNo = deliveryNo;
    }

    public String getParentDeliveryNo() {
        return parentDeliveryNo;
    }

    public void setParentDeliveryNo(String parentDeliveryNo) {
        this.parentDeliveryNo = parentDeliveryNo;
    }

    public Integer getSplitFlag() {
        return splitFlag;
    }

    public void setSplitFlag(Integer splitFlag) {
        this.splitFlag = splitFlag;
    }

    public String getThirdPayNo() {
        return thirdPayNo;
    }

    public void setThirdPayNo(String thirdPayNo) {
        this.thirdPayNo = thirdPayNo;
    }

    public String getDelivererId() {
        return delivererId;
    }

    public void setDelivererId(String delivererId) {
        this.delivererId = delivererId;
    }

    public String getShippingType() {
        return shippingType;
    }

    public void setShippingType(String shippingType) {
        this.shippingType = shippingType;
    }

    public String getWarehouseSerial() {
        return warehouseSerial;
    }

    public void setWarehouseSerial(String warehouseSerial) {
        this.warehouseSerial = warehouseSerial;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }


    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getPickupType() {
        return pickupType;
    }

    public void setPickupType(String pickupType) {
        this.pickupType = pickupType;
    }

    public String getDeliveryName() {
        return deliveryName;
    }

    public void setDeliveryName(String deliveryName) {
        this.deliveryName = deliveryName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getDeliveryMobile() {
        return deliveryMobile;
    }

    public void setDeliveryMobile(String deliveryMobile) {
        this.deliveryMobile = deliveryMobile;
    }

    public String getDeliveryPhone() {
        return deliveryPhone;
    }

    public void setDeliveryPhone(String deliveryPhone) {
        this.deliveryPhone = deliveryPhone;
    }

    public Integer getIdentityType() {
        return identityType;
    }

    public void setIdentityType(Integer identityType) {
        this.identityType = identityType;
    }

    public String getIdentityNo() {
        return identityNo;
    }

    public void setIdentityNo(String identityNo) {
        this.identityNo = identityNo;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCountryName() {
        return countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getStreetName() {
        return streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getDetailed() {
        return detailed;
    }

    public void setDetailed(String detailed) {
        this.detailed = detailed;
    }

    public String getPostcode() {
        return postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getDeliveryOrderCode() {
        return deliveryOrderCode;
    }

    public void setDeliveryOrderCode(String deliveryOrderCode) {
        this.deliveryOrderCode = deliveryOrderCode;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getShippingCompany() {
        return shippingCompany;
    }

    public void setShippingCompany(String shippingCompany) {
        this.shippingCompany = shippingCompany;
    }

    public String getExpressCode() {
        return expressCode;
    }

    public void setExpressCode(String expressCode) {
        this.expressCode = expressCode;
    }

    public Integer getScheduleType() {
        return scheduleType;
    }

    public void setScheduleType(Integer scheduleType) {
        this.scheduleType = scheduleType;
    }

    public String getScheduleDay() {
        return scheduleDay;
    }

    public void setScheduleDay(String scheduleDay) {
        this.scheduleDay = scheduleDay;
    }

    public String getScheduleStartTime() {
        return scheduleStartTime;
    }

    public void setScheduleStartTime(String scheduleStartTime) {
        this.scheduleStartTime = scheduleStartTime;
    }

    public String getScheduleEndTime() {
        return scheduleEndTime;
    }

    public void setScheduleEndTime(String scheduleEndTime) {
        this.scheduleEndTime = scheduleEndTime;
    }

    public String getDeliveryMethod() {
        return deliveryMethod;
    }

    public void setDeliveryMethod(String deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getChannel() {
        return channel;
    }

    public String getDeliveryStatus() {
        return deliveryStatus;
    }

    public void setDeliveryStatus(String deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }
}
