package com.dtyunxi.yundt.cube.center.inventory.api.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

public class StockChangeDto implements Serializable {
    /**
     * 用于处理消息幂等性(业务调用不用设值)
     */
    private String messageId;

    /**
     * 库存变更类型：用于库存变更判断 com.dtyunxi.yundt.cube.center.inventory.biz.config.StockConst.STOCK_CHANGE_TYPE
     */
    private String changeType;
    /**
     * 业务类型：可用于业务数据过滤 com.dtyunxi.yundt.cube.center.inventory.biz.config.StockConst.STOCK_BIZ_TYPE
     */
    private String bizType;
    /**
     * 库存修改对象列表
     */
    private List<StockChangeItemDto> items;
    /**
     * 是否检查库存: 为false时不检查, null或true时检查.
     */
    private Boolean checkStock;

    /**
     * 单据编码
     */
    private String orderNo;

    /**
     * 状态
     */
    private String status;

    public String getMessageId() {
        return messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public List<StockChangeItemDto> getItems() {
        return items;
    }

    public void setItems(List<StockChangeItemDto> items) {
        this.items = items;
    }

    public Boolean getCheckStock() {
        return checkStock;
    }

    public void setCheckStock(Boolean checkStock) {
        this.checkStock = checkStock;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }


    public static class StockChangeItemDto implements Serializable {

        /**
         * 仓库ID
         */
        private Long warehouseId;
        /**
         * 货品ID
         */
        private Long cargoId;
        /**
         * 批次号
         */
        private String batch;
        /**
         * 版本号
         */
        private String version;

        /**
         * 库存修改列表
         */
        private List<Stock> stocks;

        public StockChangeItemDto() {
        }

        public StockChangeItemDto(Long warehouseId, Long cargoId,String batch, List<Stock> stocks,String version) {
            this.warehouseId = warehouseId;
            this.cargoId = cargoId;
            this.batch = batch;
            this.stocks = stocks;
            this.version = version;
        }

        public String getVersion() {
            return version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getBatch() {
            return batch;
        }

        public void setBatch(String batch) {
            this.batch = batch;
        }

        public Long getWarehouseId() {
            return warehouseId;
        }

        public void setWarehouseId(Long warehouseId) {
            this.warehouseId = warehouseId;
        }

        public Long getCargoId() {
            return cargoId;
        }

        public void setCargoId(Long cargoId) {
            this.cargoId = cargoId;
        }

        public List<Stock> getStocks() {
            return stocks;
        }

        public void setStocks(List<Stock> stocks) {
            this.stocks = stocks;
        }
    }
    public static class Stock implements Serializable{
        /**
         * 库存类型: 数据库字段名 StockConst.STOCK_TYPE_开头
         */
        private String stockType;

        /**
         * 库存增量:正数代表增加，负数代表扣减
         */
        private BigDecimal num;

        public Stock() {
        }

        public Stock(String stockType, BigDecimal num) {
            this.stockType = stockType;
            this.num = num;
        }

        public String getStockType() {
            return stockType;
        }

        public void setStockType(String stockType) {
            this.stockType = stockType;
        }

        public BigDecimal getNum() {
            return num;
        }

        public void setNum(BigDecimal num) {
            this.num = num;
        }
    }
}
