/*
 * CargoQueryReqDto.class 1.0 2018-09-10
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 货品查询Dto
 *
 * @author 纳兰
 * @since 2.0.0
 */
@ApiModel(value = "CargoQueryReqDto", description = "货品查询Dto")
public class CargoQueryReqDto extends BaseVo {

    @ApiModelProperty(name = "code", value = "货品编号")
    private String code;

    @ApiModelProperty(name = "name", value = "货品名称")
    private String name;

    /**
     * 分组ID
     */
    @ApiModelProperty(name = "groupId", value = "分组ID")
    private Long groupId;
    /**
     * 单位
     */
    @ApiModelProperty(name = "unit", value = "单位")
    private String unit;

    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "brandCode", value = "品牌编码")
    private String brandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "brandName", value = "品牌名称")
    private String brandName;

    /**
     * 产地
     */
    @ApiModelProperty(name = "placeOfOrigin", value = "产地")
    private String placeOfOrigin;


    /**
     * 线下安全库存
     */
    @ApiModelProperty(name = "offlineSafetyStock", value = "线下安全库存")
    private BigDecimal offlineSafetyStock;

    /**
     * 线下是否可售
     */
    @ApiModelProperty(name = "ifAvailableOffline", value = "线下是否可售，0-不可售，1-可售")
    private Integer ifAvailableOffline;

    /**
     * 安全库存策略，0-关闭，1-开启
     */
    @ApiModelProperty(name = "safetyStockStrategy", value = "安全库存策略，0-开启，1-关闭")
    private Integer safetyStockStrategy;

    /**
     * 防超卖库存数
     */
    @ApiModelProperty(name = "avoidOversoldInventory", value = "防超卖库存数")
    private BigDecimal avoidOversoldInventory;

    /**
     * 单渠道共享数
     */
    @ApiModelProperty(name = "singleChannelShare", value = "单渠道共享数")
    private BigDecimal singleChannelShare;

    /**
     * 库存检查配置
     */
    @ApiModelProperty(name = "checkConfigId", value = "库存检查配置")
    private Long checkConfigId;

    /**
     * 拆包配置
     */
    @ApiModelProperty(name = "packageSplitId", value = "拆包配置")
    private Long packageSplitId;

    /**
     * 货品条码
     */
    @ApiModelProperty(name = "barCode", value = "货品条码")
    private String barCode;

    /**
     * 货品货号
     */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;

    /**
     * 所属客户编码
     */
    @ApiModelProperty(name = "customerNo", value = "所属客户编码")
    private String customerNo;

    /**
     * 更新时间（开始）
     */
    @ApiModelProperty(name = "updateTimeStart", value = "更新时间（开始）")
    private String updateTimeStart;

    /**
     * 更新时间（结束）
     */
    @ApiModelProperty(name = "updateTimeEnd", value = "更新时间（结束）")
    private String updateTimeEnd;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Long getCheckConfigId() {
        return checkConfigId;
    }

    public void setCheckConfigId(Long checkConfigId) {
        this.checkConfigId = checkConfigId;
    }

    public Long getPackageSplitId() {
        return packageSplitId;
    }

    public void setPackageSplitId(Long packageSplitId) {
        this.packageSplitId = packageSplitId;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getUpdateTimeStart() {
        return updateTimeStart;
    }

    public void setUpdateTimeStart(String updateTimeStart) {
        this.updateTimeStart = updateTimeStart;
    }

    public String getUpdateTimeEnd() {
        return updateTimeEnd;
    }

    public void setUpdateTimeEnd(String updateTimeEnd) {
        this.updateTimeEnd = updateTimeEnd;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getPlaceOfOrigin() {
        return placeOfOrigin;
    }

    public void setPlaceOfOrigin(String placeOfOrigin) {
        this.placeOfOrigin = placeOfOrigin;
    }

    public BigDecimal getOfflineSafetyStock() {
        return offlineSafetyStock;
    }

    public void setOfflineSafetyStock(BigDecimal offlineSafetyStock) {
        this.offlineSafetyStock = offlineSafetyStock;
    }

    public Integer getIfAvailableOffline() {
        return ifAvailableOffline;
    }

    public void setIfAvailableOffline(Integer ifAvailableOffline) {
        this.ifAvailableOffline = ifAvailableOffline;
    }

    public Integer getSafetyStockStrategy() {
        return safetyStockStrategy;
    }

    public void setSafetyStockStrategy(Integer safetyStockStrategy) {
        this.safetyStockStrategy = safetyStockStrategy;
    }

    public BigDecimal getAvoidOversoldInventory() {
        return avoidOversoldInventory;
    }

    public void setAvoidOversoldInventory(BigDecimal avoidOversoldInventory) {
        this.avoidOversoldInventory = avoidOversoldInventory;
    }

    public BigDecimal getSingleChannelShare() {
        return singleChannelShare;
    }

    public void setSingleChannelShare(BigDecimal singleChannelShare) {
        this.singleChannelShare = singleChannelShare;
    }
}
