/**
 * @(#) CargoStorageReqDto.java 1.0 2018-09-06
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 货品库存创建Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "CargoStorageCreateReqDto", description = "货品库存创建Dto")
public class CargoStorageCreateReqDto extends BaseVo {

    /**
     * 省编码
     */
    @ApiModelProperty(name = "provCode", value = "省编码，选填。当cargoList的仓库id为空时，则省市区编码必填")
    private String provCode;
    /**
     * 市编码
     */
    @ApiModelProperty(name = "cityCode", value = "市编码，选填")
    private String cityCode;
    /**
     * 区编码
     */
    @ApiModelProperty(name = "areaCode", value = "区编码，选填")
    private String areaCode;
    /**
     * 交易订单编号
     */
    @ApiModelProperty(name = "orderNo", value = "交易订单编号，必填")
    @NotNull(message = "交易订单编号不能为空")
    private String orderNo;

    /**
     * 要扣减货品的信息
     */
    @ApiModelProperty(name = "cargoList", value = "要扣减货品的信息，必填")
    @NotNull(message = "货品扣减信息不能为空")
    private List<CargoStorageInfoCreateReqDto> cargoList;
    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID，必填")
    @NotNull(message = "实力ID不能为空")
    private Long instanceId;
    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID，必填")
    @NotNull(message = "租户ID不能为空")
    private Long tenantId;

    public String getProvCode() {
        return provCode;
    }

    public void setProvCode(String provCode) {
        this.provCode = provCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public List<CargoStorageInfoCreateReqDto> getCargoList() {
        return cargoList;
    }

    public void setCargoList(List<CargoStorageInfoCreateReqDto> cargoList) {
        this.cargoList = cargoList;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}
