/**
 * @(#) CargoStorageDetailQueryReqDto.java 1.0 2018-09-07
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 管理端：货品库存查询Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "CargoStorageDetailQueryReqDto", description = "管理端：货品库存查询Dto")
public class CargoStorageDetailQueryReqDto extends BaseVo {

    /**
     * 分组ID
     */
    @ApiModelProperty(name = "groupId", value = "管理端用:分组ID")
    private Long groupId;
    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "管理端用:仓库ID")
    private Long warehouseId;
    /**
     * 仓位ID
     */
    @ApiModelProperty(name = "positionId", value = "管理端用:仓位ID")
    private Long positionId;
    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoId", value = "管理端用:货品ID")
    private Long cargoId;
    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID，必填")
    private Long instanceId;
    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID，必填")
    private Long tenantId;

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public Long getPositionId() {
        return positionId;
    }

    public void setPositionId(Long positionId) {
        this.positionId = positionId;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}
