/**
 * @(#) CargoStorageInfoCreateReqDto.java 1.0 2018-09-07
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 货品库存扣减货品Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "CargoStorageInfoCreateReqDto", description = "货品库存扣减货品Dto")
public class CargoStorageInfoCreateReqDto extends BaseVo {

    /**
     * 货品ID
     */
//    @NotNull
    @ApiModelProperty(name = "cargoId", value = "货品ID，选填")
    private Long cargoId;

    @ApiModelProperty(name = "cargoCode",value = "货品编码，必填")
    private String cargoCode;
    /**
     * 仓库ID
     */
//    @NotNull
    @ApiModelProperty(name = "warehouseId", value = "仓库ID，可选")
    private Long warehouseId;

    @ApiModelProperty(name = "warehouseCode",value = "仓库编码，可选")
    private String warehouseCode;
    /**
     * 货品库存扣减数量
     */
    @NotNull
    @ApiModelProperty(name = "num", value = "货品库存扣减数量，必填，不能为0")
    private BigDecimal num;

    /**
     * 类型（1，预占，2扣减 ,3: 增加,4:库存计算扣减）
     */
    @NotNull
    @ApiModelProperty(name = "type", value = "类型（1，预占，2扣减,3: 增加,4:库存计算扣减）")
    private Integer type;

    @ApiModelProperty(name = "used", value = "是否已使用(0-否  1-是)")
    private Integer used;

    public Integer getUsed() {
        return used;
    }

    public void setUsed(Integer used) {
        this.used = used;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }
}
