/**
 * @(#) CargoStorageDto.java 1.0 2018-09-05
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 消费端：货品可用库存查询入参Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "CargoStorageInfoQueryReqDto", description = "消费端：货品可用库存查询入参Dto")
public class CargoStorageInfoQueryReqDto extends BaseVo {

    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoId", value = "货品ID,与货品code二选一 必填")
    private Long cargoId;
    @ApiModelProperty(name = "cargoId", value = "货品code")
    private String cargoCode;

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID，与仓库Code二选一 必填")
    private Long warehouseId;

    @ApiModelProperty(name = "warehouseId", value = "仓库Code")
    private String warehouseCode;

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }
}
