/**
 * @(#) CargoStorageQueryReqDto.java 1.0 2018-09-05
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 消费端:货品库存查询Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "CargoStorageQueryReqDto", description = "消费端：货品库存查询Dto")
public class CargoStorageQueryReqDto extends BaseVo {

    /**
     * 省编码
     */
    @ApiModelProperty(name = "provCode", value = "省编码-（选填）")
    private String provCode;
    /**
     * 市编码
     */
    @ApiModelProperty(name = "cityCode", value = "市编码-（选填）")
    private String cityCode;
    /**
     * 区编码
     */
    @ApiModelProperty(name = "areaCode", value = "区编码-（选填）")
    private String areaCode;
    /**
     * 要查询库存可用货品信息集合
     */
    @ApiModelProperty(name = "cargoStorageList", value = "消费端：要查询库存可用货品信息集合")
    private List<CargoStorageInfoQueryReqDto> cargoStorageList;
    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID, 必填参数")
    private Long instanceId;
    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID, 必填参数")
    private Long tenantId;

    public String getProvCode() {
        return provCode;
    }

    public void setProvCode(String provCode) {
        this.provCode = provCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public List<CargoStorageInfoQueryReqDto> getCargoStorageList() {
        return cargoStorageList;
    }

    public void setCargoStorageList(List<CargoStorageInfoQueryReqDto> cargoStorageList) {
        this.cargoStorageList = cargoStorageList;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}
