/**
 * @(#) CargoStorageRestReqDto.java 1.0 2019-09-03
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 重置货品缓存请求Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "CargoStorageRestReqDto", description = "重置货品缓存请求Dto")
public class CargoStorageRestReqDto extends BaseVo {
    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoIdList", value = "货品ID，选填")
    private List<Long> cargoIdList;
    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID，必填")
    private Long instanceId;
    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID，必填")
    private Long tenantId;

    public List<Long> getCargoIdList() {
        return cargoIdList;
    }

    public void setCargoIdList(List<Long> cargoIdList) {
        this.cargoIdList = cargoIdList;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}
