package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;

import javax.persistence.Column;

/**
 * 货品库存共享任务请求Dto
 *
 * @ClassName CargoStorageShareTaskReqDto
 * @Author chunjiu
 * @Date 2020/9/15 19:44
 */
@ApiModel(value = "CargoStorageShareTaskReqDto", description = "货品库存共享任务请求Dto")
public class CargoStorageShareTaskReqDto extends BaseVo {

    /**
     * 任务编号
     */
    @Column(name = "taskCode")
    private Long taskCode;

    /**
     * 任务名称
     */
    @Column(name = "taskName")
    private String taskName;

    /**
     * 任务类型：1：库存共享
     */
    @Column(name = "taskType")
    private Integer taskType;

    /**
     * 任务状态：0：待执行；1：执行成功；2：执行失败
     */
    @Column(name = "taskStatus")
    private Integer taskStatus;

    /**
     * 任务备注：搜索条件+仓库分配比例
     */
    @Column(name = "taskRemark")
    private String taskRemark;

    /**
     * 任务结果（执行备注）
     */
    @Column(name = "taskResult")
    private String taskResult;

    public Long getTaskCode() {
        return taskCode;
    }

    public void setTaskCode(Long taskCode) {
        this.taskCode = taskCode;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Integer getTaskType() {
        return taskType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public Integer getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getTaskRemark() {
        return taskRemark;
    }

    public void setTaskRemark(String taskRemark) {
        this.taskRemark = taskRemark;
    }

    public String getTaskResult() {
        return taskResult;
    }

    public void setTaskResult(String taskResult) {
        this.taskResult = taskResult;
    }
}
