package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 库存流水Dto对象
 */
@ApiModel(value = "ChangeLogDto", description = "ChangeLogDto对象")
public class ChangeLogPageReqDto extends RequestDto {

    /**
     * 更新时间起始时间
     */
    @ApiModelProperty(name = "updateStartTime", value = " 更新时间起始时间  ", allowEmptyValue = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String updateStartTime;

    /**
     * 更新时间结束时间
     */
    @ApiModelProperty(name = "updateEndTime", value = " 更新时间结束时间  ", allowEmptyValue = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String updateEndTime;

    /**
     *
     */
    @ApiModelProperty(name = "id", value = "   ", allowEmptyValue = true)
    private Long id;

    /**
     * 关联单号
     */
    @ApiModelProperty(name = "relevanceNo", value = " 关联单号  ", allowEmptyValue = true)
    private String relevanceNo;

    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoId", value = " 货品ID  ", allowEmptyValue = true)
    private Long cargoId;

    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = " 货品编码  ", allowEmptyValue = true)
    private String cargoCode;

    /**
     * 货品名称
     */
    @ApiModelProperty(name = "cargoName", value = " 货品名称  ", allowEmptyValue = true)
    private String cargoName;

    /**
     * 货品货号
     */
    @ApiModelProperty(name = "cargoNo", value = " 货品货号  ", allowEmptyValue = true)
    private String cargoNo;

    /**
     * 货品条码
     */
    @ApiModelProperty(name = "cargoBarCode", value = " 货品条码  ", allowEmptyValue = true)
    private String cargoBarCode;

    /**
     * 所属客户
     */
    @ApiModelProperty(name = "clientId", value = " 所属客户  ", allowEmptyValue = true)
    private Long clientId;

    /**
     * 所属客户名称
     */
    @ApiModelProperty(name = "clientName", value = " 所属客户名称  ", allowEmptyValue = true)
    private String clientName;

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = " 仓库ID  ", allowEmptyValue = true)
    private String warehouseId;

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = " 仓库编码  ", allowEmptyValue = true)
    private String warehouseCode;

    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = " 仓库名称  ", allowEmptyValue = true)
    private String warehouseName;

    /**
     * 仓库子类型： 0 其他仓，1电商仓，2小程序仓
     */
    @ApiModelProperty(name = "warehouseSubType", value = " 仓库子类型： 0 其他仓，1电商仓，2小程序仓  ", allowEmptyValue = true)
    private Integer warehouseSubType;

    /**
     * 类型：1：销售订单、2：售后订单:3：配货单:4：补货单:5：调货单、6：返货单、7：库存调整
     */
    @ApiModelProperty(name = "type", value = " 类型：1：销售订单、2：售后订单:3：配货单:4：补货单:5：调货单、6：返货单、7：库存调整  ", allowEmptyValue = true)
    private Integer type;

    /**
     * 原库存数
     */
    @ApiModelProperty(name = "oldNum", value = " 原库存数  ", allowEmptyValue = true)
    private BigDecimal oldNum;

    /**
     * 更改库存数
     */
    @ApiModelProperty(name = "changeNum", value = " 更改库存数  ", allowEmptyValue = true)
    private BigDecimal changeNum;

    /**
     * 新库存数
     */
    @ApiModelProperty(name = "newNum", value = " 新库存数  ", allowEmptyValue = true)
    private BigDecimal newNum;

    /**
     * 创建人
     */
    @ApiModelProperty(name = "createPerson", value = " 创建人  ", allowEmptyValue = true)
    private String createPerson;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = " 创建时间  ", allowEmptyValue = true)
    private Date createTime;

    /**
     * 修改人
     */
    @ApiModelProperty(name = "updatePerson", value = " 修改人  ", allowEmptyValue = true)
    private String updatePerson;

    /**
     * 最近一次修改时间
     */
    @ApiModelProperty(name = "updateTime", value = " 最近一次修改时间  ", allowEmptyValue = true)
    private Date updateTime;

    /**
     * 每页数
     */
    @ApiModelProperty(name = "pageSize", value = "每页数")
    private Integer pageSize;

    public String getUpdateStartTime() {
        return updateStartTime;
    }

    public void setUpdateStartTime(String updateStartTime) {
        this.updateStartTime = updateStartTime;
    }

    public String getUpdateEndTime() {
        return updateEndTime;
    }

    public void setUpdateEndTime(String updateEndTime) {
        this.updateEndTime = updateEndTime;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    /**
     * 页码
     */
    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setRelevanceNo(String relevanceNo) {
        this.relevanceNo = relevanceNo;
    }

    public String getRelevanceNo() {
        return this.relevanceNo;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public Long getCargoId() {
        return this.cargoId;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoCode() {
        return this.cargoCode;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getCargoName() {
        return this.cargoName;
    }

    public void setCargoNo(String cargoNo) {
        this.cargoNo = cargoNo;
    }

    public String getCargoNo() {
        return this.cargoNo;
    }

    public void setCargoBarCode(String cargoBarCode) {
        this.cargoBarCode = cargoBarCode;
    }

    public String getCargoBarCode() {
        return this.cargoBarCode;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public Long getClientId() {
        return this.clientId;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseId() {
        return this.warehouseId;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseCode() {
        return this.warehouseCode;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseName() {
        return this.warehouseName;
    }

    public void setWarehouseSubType(Integer warehouseSubType) {
        this.warehouseSubType = warehouseSubType;
    }

    public Integer getWarehouseSubType() {
        return this.warehouseSubType;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return this.type;
    }

    public void setOldNum(BigDecimal oldNum) {
        this.oldNum = oldNum;
    }

    public BigDecimal getOldNum() {
        return this.oldNum;
    }

    public void setChangeNum(BigDecimal changeNum) {
        this.changeNum = changeNum;
    }

    public BigDecimal getChangeNum() {
        return this.changeNum;
    }

    public void setNewNum(BigDecimal newNum) {
        this.newNum = newNum;
    }

    public BigDecimal getNewNum() {
        return this.newNum;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public String getCreatePerson() {
        return this.createPerson;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public String getUpdatePerson() {
        return this.updatePerson;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

}