/**
 * @(#)CommonRequestDto.java 1.0 2018年9月26日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 通用请求Dto
 *
 * @author 水镜
 * @since 2.0.0
 */
@ApiModel(value = "CommonRequestDto", description = "通用请求Dto")
public class CommonRequestDto extends BaseVo {

    private static final long serialVersionUID = 1L;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID，必填")
    @NotNull(message = "应用实例ID不能为空")
    private Long instanceId;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID，必填")
    @NotNull(message = "租户ID不能为空")
    private Long tenantId;

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

}
