package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 更新发货单请求dto
 *
 * @author: fuyun
 * @Date: 2020/9/8 16:35
 */
@ApiModel(value = "ChangeDeliveryReqDto", description = "更新发货单请求dto")
public class DeliveryChangeReqDto extends BaseVo {

    @ApiModelProperty(name = "deliveryNo", value = "发货单号")
    private String deliveryNo;

    @ApiModelProperty(name = "preDeliveryStatus", value = "操作前发货单状态")
    private String preDeliveryStatus;

    @ApiModelProperty(name = "deliveryStatus", value = "发货单状态")
    private String deliveryStatus;

    @ApiModelProperty(name = "optCode", value = "操作状态编码")
    private String optCode;

    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(name = "preWarehouseCode", value = "操作前仓库编码")
    private String preWarehouseCode;

    @ApiModelProperty(name = "preWarehouseName", value = "操作前仓库名称")
    private String preWarehouseName;

    @ApiModelProperty(name = "detailDesc", value = "详细描述")
    private String detailDesc;

    @ApiModelProperty(
            name = "operatorDesc",
            value = "操作人描述"
    )
    private String operatorDesc;

    @ApiModelProperty(name = "deliveryTime", value = "发货时间")
    private Date deliveryTime;

    @ApiModelProperty(name = "receiveTime", value = "接单时间")
    private Date receiveTime;

    @ApiModelProperty(name = "organizationId", value = "所属组织ID")
    private Long organizationId;

    @ApiModelProperty(name = "organizationName", value = "所属组织名称")
    private String organizationName;

    @ApiModelProperty(name = "preOrganizationId", value = "操作前所属组织ID")
    private Long preOrganizationId;

    @ApiModelProperty(name = "preOrganizationName", value = "操作前所属组织名称")
    private String preOrganizationName;

    public String getDeliveryNo() {
        return deliveryNo;
    }

    public void setDeliveryNo(String deliveryNo) {
        this.deliveryNo = deliveryNo;
    }

    public String getDeliveryStatus() {
        return deliveryStatus;
    }

    public void setDeliveryStatus(String deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getDetailDesc() {
        return detailDesc;
    }

    public void setDetailDesc(String detailDesc) {
        this.detailDesc = detailDesc;
    }

    public String getOptCode() {
        return optCode;
    }

    public void setOptCode(String optCode) {
        this.optCode = optCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getPreDeliveryStatus() {
        return preDeliveryStatus;
    }

    public void setPreDeliveryStatus(String preDeliveryStatus) {
        this.preDeliveryStatus = preDeliveryStatus;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public Date getReceiveTime() {
        return receiveTime;
    }

    public void setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
    }

    public String getPreWarehouseCode() {
        return preWarehouseCode;
    }

    public void setPreWarehouseCode(String preWarehouseCode) {
        this.preWarehouseCode = preWarehouseCode;
    }

    public String getPreWarehouseName() {
        return preWarehouseName;
    }

    public void setPreWarehouseName(String preWarehouseName) {
        this.preWarehouseName = preWarehouseName;
    }

    public Long getPreOrganizationId() {
        return preOrganizationId;
    }

    public void setPreOrganizationId(Long preOrganizationId) {
        this.preOrganizationId = preOrganizationId;
    }

    public String getPreOrganizationName() {
        return preOrganizationName;
    }

    public void setPreOrganizationName(String preOrganizationName) {
        this.preOrganizationName = preOrganizationName;
    }

    public String getOperatorDesc() {
        return operatorDesc;
    }

    public void setOperatorDesc(String operatorDesc) {
        this.operatorDesc = operatorDesc;
    }
}
