/**
 * @(#) DeliveryOrderDto.java 1.0 2018-08-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * 发货单创建Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "DeliveryItemSumReqDto", description = "发货单商品统计")
public class DeliveryItemSumReqDto extends BaseVo {

    @ApiModelProperty(value = "开始时间")
    private Date startTime;
    @ApiModelProperty(value = "结束时间")
    private Date endTime;
    @ApiModelProperty(value = "仓库编码")
    private List<String> warehouseCodes;
    @ApiModelProperty(value = "货品编码")
    private List<String> cargoCodes;

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public List<String> getWarehouseCodes() {
        return warehouseCodes;
    }

    public void setWarehouseCodes(List<String> warehouseCodes) {
        this.warehouseCodes = warehouseCodes;
    }

    public List<String> getCargoCodes() {
        return cargoCodes;
    }

    public void setCargoCodes(List<String> cargoCodes) {
        this.cargoCodes = cargoCodes;
    }
}
