/*
 * @(#)DeliveryMessageVo.java 1.0 2018-10-19
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "DeliveryOrderInfoReqDto", description = "申请订单发货请求Dto")
public class DeliveryOrderInfoReqDto extends BaseVo {
    /**
     * 租户id
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID，必填")
    private Long tenantId;

    /**
     * 实例id
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID，必填")
    private Long instanceId;

    /**
     * 订单号
     */
    @ApiModelProperty(name = "orderNo", value = "订单号，必填")
    private String orderNo;

    /**
     * 订单状态：等待发货 wait_delivery 取消发货 cancel_delivery 发货完成success_delivery
     */
    @ApiModelProperty(name = "orderStatus", value = "订单状态：等待发货 wait_delivery 取消发货 cancel_delivery 发货完成success_delivery")
    private String orderStatus;

    /**
     * 发货地址
     */
    @ApiModelProperty(name = "deliveryAddress", value = "发货地址，必填")
    private DeliveryAddressReqDto deliveryAddress;

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public DeliveryAddressReqDto getDeliveryAddress() {
        return deliveryAddress;
    }

    public void setDeliveryAddress(DeliveryAddressReqDto deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

}