package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 发货单路由请求dto
 *
 * @author: fuyun
 * @Date: 2020/9/8 10:10
 */
@ApiModel(value = "DeliveryRouteReqDto", description = "发货单路由请求dto")
public class DeliveryRouteReqDto extends BaseVo {

    @ApiModelProperty(name = "deliveryNo", value = "发货单号")
    private String deliveryNo;

    @ApiModelProperty(name = "deliveryStatus", value = "发货单状态")
    private String deliveryStatus;

    @ApiModelProperty(name = "warehouseCode", value = "发货仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "warehouseSubType", value = "发货仓库子类型")
    private String warehouseSubType;

    @ApiModelProperty(name = "routeCount", value = "路由次数")
    private Integer routeCount = 1;

    public String getDeliveryNo() {
        return deliveryNo;
    }

    public void setDeliveryNo(String deliveryNo) {
        this.deliveryNo = deliveryNo;
    }

    public String getDeliveryStatus() {
        return deliveryStatus;
    }

    public void setDeliveryStatus(String deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseSubType() {
        return warehouseSubType;
    }

    public void setWarehouseSubType(String warehouseSubType) {
        this.warehouseSubType = warehouseSubType;
    }

    public Integer getRouteCount() {
        return routeCount;
    }

    public void setRouteCount(Integer routeCount) {
        this.routeCount = routeCount;
    }
}
