package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;

/**
 * @author: liuji
 * @Date: 2020-06-22 13:50
 * @since 2.0.0
 */
@ApiModel(value = "OrderRouteRuleReqDto", description = "订单路由规则请求Dto")
public class OrderRouteRuleReqDto extends RequestDto {

    @ApiModelProperty(name = "id", value = "主键")
    private Long id;

    @ApiModelProperty(name = "routeRuleName", value = "路由规则名称")
    @NotBlank(message = "路由规则名称不能为空")
    private String routeRuleName;

    @ApiModelProperty(name = "applicableChannel", value = "适用渠道")
    @NotBlank(message = "适用渠道不能为空")
    private String applicableChannel;

    @ApiModelProperty(name = "routeType", value = "路由类型")
    @NotBlank(message = "路由类型不能为空")
    private String routeType;

    @ApiModelProperty(name = "routeStatus", value = "路由状态（0 启用，1 禁用）")
    private Integer routeStatus;

    @ApiModelProperty(name = "splitFlag", value = "是否拆单（0 拆单，1 不拆单）")
    private Integer splitFlag;

    @ApiModelProperty(name = "giftDeliveryWarehouse", value = "赠品发货仓库")
    private String giftDeliveryWarehouse;

    @ApiModelProperty(name = "deliveryWarehouseCode", value = "发货仓库编码")
    private String deliveryWarehouseCode;

    @ApiModelProperty(name = "inventoryPriority", value = "库存优先级（0 库存优先，1 路由得分优先）")
    private Integer inventoryPriority;

    @ApiModelProperty(name = "inventoryPriorityItem", value = "库存规则信息（json格式存放 ）[\"0\",\"1\",\"2\"]")
    private String inventoryPriorityItem;

    @ApiModelProperty(name = "weightItem", value = "规则因素信息（json格式存放权重项）[{\"type\":\"0\",\"ration\":40,\"id\":\"1\"},{\"type\":\"1\",\"ration\":30,\"id\":\"1575853392564\"}]")
    private String weightItem;

    @ApiModelProperty(name = "extension", value = "扩展值")
    private String extension;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRouteRuleName() {
        return routeRuleName;
    }

    public void setRouteRuleName(String routeRuleName) {
        this.routeRuleName = routeRuleName;
    }

    public String getApplicableChannel() {
        return applicableChannel;
    }

    public void setApplicableChannel(String applicableChannel) {
        this.applicableChannel = applicableChannel;
    }

    public String getRouteType() {
        return routeType;
    }

    public void setRouteType(String routeType) {
        this.routeType = routeType;
    }

    public Integer getRouteStatus() {
        return routeStatus;
    }

    public void setRouteStatus(Integer routeStatus) {
        this.routeStatus = routeStatus;
    }

    public Integer getSplitFlag() {
        return splitFlag;
    }

    public void setSplitFlag(Integer splitFlag) {
        this.splitFlag = splitFlag;
    }

    public String getGiftDeliveryWarehouse() {
        return giftDeliveryWarehouse;
    }

    public void setGiftDeliveryWarehouse(String giftDeliveryWarehouse) {
        this.giftDeliveryWarehouse = giftDeliveryWarehouse;
    }

    public Integer getInventoryPriority() {
        return inventoryPriority;
    }

    public void setInventoryPriority(Integer inventoryPriority) {
        this.inventoryPriority = inventoryPriority;
    }

    public String getInventoryPriorityItem() {
        return inventoryPriorityItem;
    }

    public void setInventoryPriorityItem(String inventoryPriorityItem) {
        this.inventoryPriorityItem = inventoryPriorityItem;
    }

    public String getWeightItem() {
        return weightItem;
    }

    public void setWeightItem(String weightItem) {
        this.weightItem = weightItem;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getDeliveryWarehouseCode() {
        return deliveryWarehouseCode;
    }

    public void setDeliveryWarehouseCode(String deliveryWarehouseCode) {
        this.deliveryWarehouseCode = deliveryWarehouseCode;
    }
}
