/*
 * PositionCreateReqDto.class 1.0 2018-09-03
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 仓位创建Dto
 *
 * @author 纳兰
 * @since 2.0.0
 */
@ApiModel(value = "PositionCreateReqDto", description = "仓位创建Dto")
public class PositionCreateReqDto extends BaseVo {
    /**
     * 仓位编码
     */
    @ApiModelProperty(name = "code", value = "仓位编码，addPosition接口调用时不能为空")
    @NotNull(message = "仓位编码不能为空")
    private String code;
    /**
     * 仓位名称
     */
    @ApiModelProperty(name = "name", value = "仓位名称")
    @NotNull(message = "仓位名称不能为空")
    private String name;
    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID，addPosition接口调用时不能为空")
    @NotNull(message = "仓库ID不能为空")
    private Long warehouseId;
    /**
     * REAL 实体仓位   NETWORK网络仓位
     */
    @ApiModelProperty(name = "type", value = "REAL 实体仓位   NETWORK网络仓位，addPosition接口调用时不能为空")
    private String type;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID，addPosition接口调用时不能为空")
    @NotNull(message = "应用实例ID不能为空")
    private Long instanceId;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    @NotNull(message = "租户实例不能为空")
    private Long tenantId;
}
