/*
 * PositionUpdateReqDto.class 1.0 2018-09-03
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 仓位更新Dto
 *
 * @author 纳兰
 * @since 2.0.0
 */
@ApiModel(value = "PositionUpdateReqDto", description = "仓位更新Dto")
public class PositionUpdateReqDto extends BaseVo {
    /**
     * 仓位名称
     */
    @ApiModelProperty(name = "name", value = "仓位名称")
    private String name;

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    /**
     * REAL 实体仓位   NETWORK网络仓位
     */
    @ApiModelProperty(name = "type", value = "REAL 实体仓位   NETWORK网络仓位")
    private String type;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }
}
