/*
 * @(#)InventoryException.java 1.0 2018-08-30
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 仓库和服务区关联请求Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "RAreaWarehouseReqDto", description = "仓库和服务区关联请求Dto")
public class RAreaWarehouseReqDto extends BaseVo {

    private Long id;

    /**
     * 实例ID
     */
    @NotNull(message = "实例id不能为空")
    @ApiModelProperty(name = "instanceId", value = "实例ID，relateToServiceArea接口调用时不能为空")
    private Long instanceId;

    /**
     * 仓库ID
     */
    @NotNull(message = "仓库id不能为空")
    @ApiModelProperty(name = "warehouseId", value = "仓库ID，relateToServiceArea接口调用时不能为空")
    private Long warehouseId;

    /**
     * 服务区ID
     */
    @NotNull(message = "服务区id不能为空")
    @ApiModelProperty(name = "serviceAreaId", value = "服务区ID，relateToServiceArea接口调用时不能为空")
    private Long serviceAreaId;

    /**
     * 分组ID
     */
    @NotNull(message = "分组id不能为空")
    @ApiModelProperty(name = "groupId", value = "分组ID，relateToServiceArea接口调用时不能为空")
    private Long groupId;

    /**
     * 设置主键ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 获取主键ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 设置实例ID
     */
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * 获取实例ID
     */
    public Long getInstanceId() {
        return this.instanceId;
    }

    /**
     * 设置仓库ID
     */
    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    /**
     * 获取仓库ID
     */
    public Long getWarehouseId() {
        return this.warehouseId;
    }

    /**
     * 设置服务器ID
     */
    public void setServiceAreaId(Long serviceAreaId) {
        this.serviceAreaId = serviceAreaId;
    }

    /**
     * 获取服务器ID
     */
    public Long getServiceAreaId() {
        return this.serviceAreaId;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }
}