/*
 * @(#) RServiceAreaReqDto.java 1.0 2018-11-09
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务区和区域关联 ReqDto
 *
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "RServiceAreaReqDto", description = "服务区和区域关联")
public class RServiceAreaReqDto extends BaseVo {
    /**
     * 分组ID
     */
    @ApiModelProperty(name = "groupId", value = "分组ID，新增时不能为空")
    private Long groupId;
    /**
     * 服务区ID
     */
    @ApiModelProperty(name = "serviceAreaId", value = "服务区ID，新增时不能为空")
    private Long serviceAreaId;
    /**
     * 省编码
     */
    @ApiModelProperty(name = "provCode", value = "省编码")
    private String provCode;
    /**
     * 市编码
     */
    @ApiModelProperty(name = "cityCode", value = "市编码")
    private String cityCode;
    /**
     * 区编码
     */
    @ApiModelProperty(name = "areaCode", value = "区编码")
    private String areaCode;
    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID，新增时不能为空")
    private Long instanceId;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID，新增时不能为空")
    private Long tenantId;

    /**
     * 拓展数据
     */
    @ApiModelProperty(name = "extension", value = "拓展数据")
    private String extension;

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getServiceAreaId() {
        return this.serviceAreaId;
    }

    public void setServiceAreaId(Long serviceAreaId) {
        this.serviceAreaId = serviceAreaId;
    }

    public String getProvCode() {
        return this.provCode;
    }

    public void setProvCode(String provCode) {
        this.provCode = provCode;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }


}