package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 库存规则Dto对象
 */
@ApiModel(value = "RuleDto", description = "RuleDto对象")
public class RuleReqDto extends RequestDto {

    /**
     *
     */
    @ApiModelProperty(name = "id", value = "   ", allowEmptyValue = true)
    private Long id;

    /**
     * 编码
     */
    @ApiModelProperty(name = "code", value = " 编码  ", allowEmptyValue = true)
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(name = "name", value = " 名称  ", allowEmptyValue = true)
    private String name;

    /**
     * 状态：0-禁用 1-启用
     */
    @ApiModelProperty(name = "status", value = " 状态：0-禁用 1-启用  ", allowEmptyValue = true)
    private Integer status;

    /**
     * 类型：0组合规则，1 组织规则
     */
    @ApiModelProperty(name = "type", value = " 类型：0组合规则，1 组织规则  ", allowEmptyValue = true)
    private Integer type;

    /**
     * 规则关系：0 AND，1 OR
     */
    @ApiModelProperty(name = "ruleRelationship", value = " 规则关系：0 AND，1 OR  ", allowEmptyValue = true)
    private Integer ruleRelationship;

    /**
     * 规则值
     */
    @ApiModelProperty(name = "ruleValue", value = " 规则值  ", allowEmptyValue = true)
    private String ruleValue;

    /**
     * 库存对象id
     */
    @ApiModelProperty(name = "inObjectId", value = " 库存对象id  ", allowEmptyValue = true)
    private Long inObjectId;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = " 备注  ", allowEmptyValue = true)
    private String remark;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = " 创建时间  ", allowEmptyValue = true)
    private Date createTime;

    /**
     * 创建人
     */
    @ApiModelProperty(name = "createPerson", value = " 创建人  ", allowEmptyValue = true)
    private String createPerson;

    /**
     * 最近一次修改时间
     */
    @ApiModelProperty(name = "updateTime", value = " 最近一次修改时间  ", allowEmptyValue = true)
    private Date updateTime;

    /**
     * 修改人
     */
    @ApiModelProperty(name = "updatePerson", value = " 修改人  ", allowEmptyValue = true)
    private String updatePerson;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return this.type;
    }

    public void setRuleRelationship(Integer ruleRelationship) {
        this.ruleRelationship = ruleRelationship;
    }

    public Integer getRuleRelationship() {
        return this.ruleRelationship;
    }

    public void setRuleValue(String ruleValue) {
        this.ruleValue = ruleValue;
    }

    public String getRuleValue() {
        return this.ruleValue;
    }

    public void setInObjectId(Long inObjectId) {
        this.inObjectId = inObjectId;
    }

    public Long getInObjectId() {
        return this.inObjectId;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public String getCreatePerson() {
        return this.createPerson;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public String getUpdatePerson() {
        return this.updatePerson;
    }

}