/*
 * ServiceAreaDto.class 1.0 2018-08-30
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 服务区创建Dto
 *
 * @author 吴鹏飞
 * @since 2.0.0
 */
@ApiModel(value = "ServiceAreaCreateDto", description = "服务区创建Dto")
public class ServiceAreaCreateDto extends BaseVo {
    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "租户id，addServiceArea接口调用时不能为空")
    @NotNull(message = "租户id不能为空")
    private Long instanceId;

    /**
     * 服务区编码
     */
    @ApiModelProperty(name = "code", value = "服务区编码，addServiceArea接口调用时不能为空")
    @NotNull(message = "服务区编码不能为空")
    private String code;

    /**
     * 服务区名称
     */
    @ApiModelProperty(name = "name", value = "服务区名称，addServiceArea接口调用时不能为空")
    @NotNull(message = "服务区名称不能为空")
    private String name;
    /**
     * 分组ID
     */

    @ApiModelProperty(name = "groupId", value = "分组ID，addServiceArea接口调用时不能为空")
    @NotNull(message = "分组ID不能为空")
    private Long groupId;

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    @NotNull(message = "租户实例不能为空")
    private Long tenantId;


}
