package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @author: liuji
 * @Date: 2020-07-29 10:01
 * @since 2.0.0
 */
@ApiModel(value = "StorageAdjustAuditReqDto", description = "库存调整审核请求dto")
public class StorageAdjustAuditReqDto extends RequestDto {
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;

    @ApiModelProperty(name = "status", value = "单据状态(AUDIT_PASS：审核通过、AUDIT_NO_PASS:审核不通过)")
    @NotNull(message = "审核状态不能为空")
    private String status;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}
