/**
 * @(#) CargoStorageRestReqDto.java 1.0 2019-09-03
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 重置货品请求Dto
 *
 * @author ganguo
 */
@ApiModel(value = "StorageAdjustCoverReqDto", description = "重置货品请求Dto")
public class StorageAdjustCoverReqDto extends RequestDto {

    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;

    @ApiModelProperty(name = "warehouseCode", value = "仓库code")
    private String warehouseCode;
    /**
     * 覆盖列表
     */
    @ApiModelProperty(name = "cargoStorageCoverLines", value = "覆盖列表，必填")
    private List<StorageAdjustCoverCargoReqDto> cargoStorageCoverCargos;


    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public List<StorageAdjustCoverCargoReqDto> getCargoStorageCoverCargos() {
        return cargoStorageCoverCargos;
    }

    public void setCargoStorageCoverCargos(List<StorageAdjustCoverCargoReqDto> cargoStorageCoverCargos) {
        this.cargoStorageCoverCargos = cargoStorageCoverCargos;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }
}
