package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author: liuji
 * @Date: 2020-07-20 16:44
 * @since 2.0.0
 */
@ApiModel(value = "StorageAdjustQueryReqDto", description = "库存调整查询dto")
public class StorageAdjustQueryReqDto extends RequestDto {

    @ApiModelProperty(name = "storageAdjustNo", value = "单据编号")
    private String storageAdjustNo;

    @ApiModelProperty(name = "adjustType", value = "调整类型(COMMON_ADJUST:普通调整、SYSTEM_ADJUST:系统调整)")
    private String adjustType;

    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;

    @ApiModelProperty(name = "status", value = "单据状态(WAIT_COMMIT:待提交、WAIT_AUDIT:待审核、AUDIT_PASS：审核通过、AUDIT_NO_PASS:审核不通过、SUCCESS:执行成功、FAIL:执行失败)")
    private String status;

    @ApiModelProperty(name = "direction", value = "数据方向")
    private String direction;

    @ApiModelProperty(name = "createTimeStart", value = "创建开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTimeStart;

    @ApiModelProperty(name = "createTimeEnd", value = "创建结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTimeEnd;

    public String getStorageAdjustNo() {
        return storageAdjustNo;
    }

    public void setStorageAdjustNo(String storageAdjustNo) {
        this.storageAdjustNo = storageAdjustNo;
    }

    public String getAdjustType() {
        return adjustType;
    }

    public void setAdjustType(String adjustType) {
        this.adjustType = adjustType;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDirection() {
        return direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public Date getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(Date createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public Date getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(Date createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }
}
