package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 库存变化dto
 *
 * @author: 浮云
 */
@ApiModel(value = "StorageChangeReqDto", description = "库存变化dto")
public class StorageChangeReqDto extends BaseVo {


    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;

    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "preempt", value = "预占")
    private BigDecimal preempt;

    @ApiModelProperty(name = "available", value = "可用")
    private BigDecimal available;

    @ApiModelProperty(name = "oriAvailable", value = "原可用库存数")
    private BigDecimal oriAvailable;

    @ApiModelProperty(name = "balance", value = "总库存")
    private BigDecimal balance;

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public BigDecimal getPreempt() {
        return preempt;
    }

    public void setPreempt(BigDecimal preempt) {
        this.preempt = preempt;
    }

    public BigDecimal getAvailable() {
        return available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getOriAvailable() {
        return oriAvailable;
    }

    public void setOriAvailable(BigDecimal oriAvailable) {
        this.oriAvailable = oriAvailable;
    }
}
