package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @author: liuji
 * @Date: 2020-07-03 11:09
 * @since 2.0.0
 */
@ApiModel(value = "StorageObjectReqDto", description = "库存对象请求Dto")
public class StorageObjectReqDto extends RequestDto {
    /**
     * 主键id
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;

    /**
     * 库存对象名称
     */
    @ApiModelProperty(name = "storageObjName", value = "库存对象名称")
    @NotNull(message = "库存对象名称不能为空")
    private String storageObjName;

    /**
     * 库存对象库表
     */
    @ApiModelProperty(name = "storageObjTable", value = "库存对象库表")
    @NotNull(message = "库存对象库表不能为空")
    private String storageObjTable;

    /**
     * 库存属性
     */
    @ApiModelProperty(name = "storageObjAttr", value = "库存属性")
    @NotNull(message = "库存属性不能为空")
    private String storageObjAttr;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStorageObjName() {
        return storageObjName;
    }

    public void setStorageObjName(String storageObjName) {
        this.storageObjName = storageObjName;
    }

    public String getStorageObjTable() {
        return storageObjTable;
    }

    public void setStorageObjTable(String storageObjTable) {
        this.storageObjTable = storageObjTable;
    }

    public String getStorageObjAttr() {
        return storageObjAttr;
    }

    public void setStorageObjAttr(String storageObjAttr) {
        this.storageObjAttr = storageObjAttr;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
