/*
 * @(#)StorageOrderCreateDto.java 1.0 2018-09-06
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 出入库新增Dto
 *
 * @author 书生
 * @since 2.0.0
 */
@ApiModel(value = "StorageOrderCreateDto", description = "出入库新增Dto")
public class StorageOrderCreateDto extends BaseVo {

    /**
     * 出入库单Dto
     */
    @ApiModelProperty(name = "storageOrderReqDto", value = "出入库单Dto，必填")
    private StorageOrderReqDto storageOrderReqDto;

    /**
     * 地址Dto
     */
    @ApiModelProperty(name = "addressReqDto", value = "地址Dto")
    private AddressReqDto addressReqDto;

    /**
     * 出入库单明细Dto
     */
    @ApiModelProperty(name = "storageOrderDetailReqDtoList", value = "出入库单明细Dto，必填")
    private List<StorageOrderDetailReqDto> storageOrderDetailReqDtoList;

    /**
     * 跳过审核环节，直接出库扣库存  （默认走审核环节，如传true 则跳过）
     */
    private Boolean skipAudit = false;
    /**
     * 是否校验库存，如传false则不校验库存，即可以允许负库存（默认为true检查库存）
     *
     * 注意只有skipAudit=true 时， 此参数才会生效
     */
    private Boolean checkStock = true;

    /**
     * 是否释放预占,如果传true，则出库同时调用库存释放接口对预占库存进行释放
     * 注意只有skipAudit=true 时， 此参数才会生效
     */
    private Boolean confirmPreempt = false;

    public Boolean getCheckStock() {
        return checkStock;
    }

    public void setCheckStock(Boolean checkStock) {
        this.checkStock = checkStock;
    }

    public StorageOrderReqDto getStorageOrderReqDto() {
        return storageOrderReqDto;
    }

    public void setStorageOrderReqDto(StorageOrderReqDto storageOrderReqDto) {
        this.storageOrderReqDto = storageOrderReqDto;
    }

    public List<StorageOrderDetailReqDto> getStorageOrderDetailReqDtoList() {
        return storageOrderDetailReqDtoList;
    }

    public void setStorageOrderDetailReqDtoList(List<StorageOrderDetailReqDto> storageOrderDetailReqDtoList) {
        this.storageOrderDetailReqDtoList = storageOrderDetailReqDtoList;
    }

    public AddressReqDto getAddressReqDto() {
        return addressReqDto;
    }

    public void setAddressReqDto(AddressReqDto addressReqDto) {
        this.addressReqDto = addressReqDto;
    }

    public Boolean getSkipAudit() {
        return skipAudit;
    }

    public void setSkipAudit(Boolean skipAudit) {
        this.skipAudit = skipAudit;
    }

    public Boolean getConfirmPreempt() {
        return confirmPreempt;
    }

    public void setConfirmPreempt(Boolean confirmPreempt) {
        this.confirmPreempt = confirmPreempt;
    }
}
