/*
 * @(#)StorageOrderDetailReqDto.java 1.0 2018-09-06
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 出入库单明细请求Dto
 *
 * @author 书生
 * @since 2.0.0
 */
@ApiModel(value = "StorageOrderDetailReqDto", description = "出入库单明细请求Dto")
public class StorageOrderDetailReqDto extends RequestDto {

    /**
     * ID
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;

    /**
     * 单据ID
     */
    @ApiModelProperty(name = "orderId", value = "单据ID，可选")
    private Long orderId;
    /**
     * 单据编号
     */
    @ApiModelProperty(name = "orderNo", value = "单据编号，可选")
    private String orderNo;
    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID，必填")
    private Long warehouseId;
    /**
     * 仓位ID
     */
    @ApiModelProperty(name = "positionId", value = "仓位ID，可选")
    private Long positionId;
    /**
     * 货品ID
     */
    @ApiModelProperty(name = "cargoId", value = "货品ID，必填")
    private Long cargoId;

    private String cargoCode;
    /**
     * 货品数量
     */
    @ApiModelProperty(name = "num", value = "货品数量，必填")
    private Long num;
    /**
     * UNVERIFIED未核实 VERIFIED已核实 ABNORMAL异常
     */
    @ApiModelProperty(name = "status", value = "UNVERIFIED未核实 VERIFIED已核实 ABNORMAL异常，默认未核实")
    private String status;
    /**
     * 包裹id
     */
    @ApiModelProperty(name = "packageId", value = "包裹id，可选")
    private Long packageId;
    @ApiModelProperty(name = "batch", value = "批次号")
    private String batch;

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public Long getPositionId() {
        return positionId;
    }

    public void setPositionId(Long positionId) {
        this.positionId = positionId;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public Long getNum() {
        return num;
    }

    public void setNum(Long num) {
        this.num = num;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public Long getInstanceId() {
        return instanceId;
    }

    @Override
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getPackageId() {
        return packageId;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }
}
