/*
 * @(#)StorageOrderRequestDto.java 1.0 2018-08-30
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 出入库单请求Dto
 *
 * @author 书生
 * @since 2.0.0
 */
@ApiModel(value = "StorageOrderReqDto", description = "出入库单请求Dto")
public class StorageOrderReqDto extends BaseVo {

    /**
     * 主键ID
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = " 仓库ID  ", allowEmptyValue = true)
    private Long warehouseId;
    /**
     * 仓库code
     */
    private String warehouseCode;

    /**
     * 单据id
     */
    @ApiModelProperty(name = "orderSrcId", value = " 单据id  ", allowEmptyValue = true)
    private Long orderSrcId;

    /**
     * 单据来源
     */
    @ApiModelProperty(name = "orderSrc", value = " 单据来源  ", allowEmptyValue = true)
    private String orderSrc;

    /**
     * 单据编码
     */
    @ApiModelProperty(name = "orderNo", value = " 单据编码  ", allowEmptyValue = true)
    private String orderNo;

    /**
     * 业务单号
     */
    @ApiModelProperty(name = "businessId", value = " 业务单号  ", allowEmptyValue = true)
    private String businessId;

    /**
     * 1：待提交、2：待审核:3：待出库、4：待入库，5：审核不通过、6：待发货、7：已完结、8：取消
     */
    @ApiModelProperty(name = "status", value = " 1：待提交、2：待审核:3：待出库、4：待入库，5：审核不通过、6：待发货、7：已完结、8：取消  ", allowEmptyValue = true)
    private Integer status;

    /**
     * CATEGORY_IN 入库 CATEGORY_OUT 出库
     */
    @ApiModelProperty(name = "category", value = " CATEGORY_IN 入库 CATEGORY_OUT 出库  ", allowEmptyValue = true)
    private String category;

    /**
     * 1：线上销售、 2：线下销售、 3：订货销售、 4：调配、 5：盘亏、 6：移库出库、 7：处置、 8：线上销售退货、 9：线下销售退货、 10：订货销售退货、 11：调配、 12：盘盈、 13：移库入库
     */
    @ApiModelProperty(name = "type", value = " 1：线上销售、 2：线下销售、 3：订货销售、 4：调配、 5：盘亏、 6：移库出库、 7：处置、 8：线上销售退货、 9：线下销售退货、 10：订货销售退货、 11：调配、 12：盘盈、 13：移库入库  ", allowEmptyValue = true)
    private Integer type;

    /**
     * 审核人
     */
    @ApiModelProperty(name = "auditPerson", value = " 审核人  ", allowEmptyValue = true)
    private String auditPerson;

    /**
     * 审核时间
     */
    @ApiModelProperty(name = "auditTime", value = " 审核时间  ", allowEmptyValue = true)
    private Date auditTime;

    /**
     * 创建人
     */
    @ApiModelProperty(name = "createPerson", value = " 创建人  ", allowEmptyValue = true)
    private String createPerson;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = " 创建时间  ", allowEmptyValue = true)
    private Date createTime;

    /**
     * 修改人
     */
    @ApiModelProperty(name = "updatePerson", value = " 修改人  ", allowEmptyValue = true)
    private String updatePerson;

    /**
     * 最近一次修改时间
     */
    @ApiModelProperty(name = "updateTime", value = " 最近一次修改时间  ", allowEmptyValue = true)
    private Date updateTime;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID，必填")
    private Long tenantId;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID，必填")
    private Long instanceId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public Long getOrderSrcId() {
        return orderSrcId;
    }

    public void setOrderSrcId(Long orderSrcId) {
        this.orderSrcId = orderSrcId;
    }

    public String getOrderSrc() {
        return orderSrc;
    }

    public void setOrderSrc(String orderSrc) {
        this.orderSrc = orderSrc;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getBusinessId() {
        return businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getAuditPerson() {
        return auditPerson;
    }

    public void setAuditPerson(String auditPerson) {
        this.auditPerson = auditPerson;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdatePerson() {
        return updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }
}
