package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 仓库货品请求dto
 *
 * @author: fuyun
 * @Date: 2020/7/20 14:16
 */
@ApiModel(value = "WarehouseCargoReqDto", description = "仓库货品请求dto")
public class WarehouseCargoReqDto extends RequestDto {

    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;

    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(name = "cargoId", value = "货品id")
    private Long cargoId;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;

    /**
     * 库存共享状态： 0 不开启 ，1 开启
     */
    @ApiModelProperty(name = "inventoryShareStatus", value = "库存共享状态： 0 不开启 ，1 开启")
    private Integer inventoryShareStatus;

    @ApiModelProperty(name = "customerNo", value = "所属客户编号")
    private String customerNo;


    @ApiModelProperty(name = "collectionMethod", value = "库存维度")
    private Integer collectionMethod;

    /**
     * 库存总数止
     */
    @ApiModelProperty(name = "balance", value = " 库存总数止  ", allowEmptyValue = true)
    private Long balanceMax;

    /**
     * 库存总数起
     */
    @ApiModelProperty(name = "balance", value = " 库存总数起  ", allowEmptyValue = true)
    private Long balanceMin;

    /**
     * 预占起
     */
    @ApiModelProperty(name = "preempt", value = " 预占起  ", allowEmptyValue = true)
    private Long preemptMin;

    /**
     * 预占止
     */
    @ApiModelProperty(name = "preempt", value = " 预占止  ", allowEmptyValue = true)
    private Long preemptMax;

    /**
     * 可用起
     */
    @ApiModelProperty(name = "available", value = " 可用起  ", allowEmptyValue = true)
    private Long availableMin;

    /**
     * 可用止
     */
    @ApiModelProperty(name = "available", value = " 可用止  ", allowEmptyValue = true)
    private Long availableMax;

    /**
     * GENERAL总仓 SEPERATE分仓 WHOLE全局仓库 STORE门店仓库
     */
    @ApiModelProperty(name = "warehouseType", value = " GENERAL总仓 SEPERATE分仓 WHOLE全局仓库 STORE门店仓库  ", allowEmptyValue = true)
    private String warehouseType;

    /**
     * 子类型： 0 其他仓，1电商仓，2第三方小程序仓，3自有小程序仓
     */
    @ApiModelProperty(name = "warehouseSubType", value = " 子类型： 0 其他仓，1电商仓，2第三方小程序仓，3自有小程序仓  ", allowEmptyValue = true)
    private Integer warehouseSubType;

    @ApiModelProperty(name = "updateTimeStart", value = "更新时间（开始）")
    private String updateTimeStart;

    @ApiModelProperty(name = "updateTimeEnd", value = "更新时间（结束）")
    private String updateTimeEnd;

    /**
     * 每页数
     */
    @ApiModelProperty(name = "pageSize", value = "每页数")
    private Integer pageSize;

    /**
     * 页码
     */
    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getUpdateTimeStart() {
        return updateTimeStart;
    }

    public void setUpdateTimeStart(String updateTimeStart) {
        this.updateTimeStart = updateTimeStart;
    }

    public String getUpdateTimeEnd() {
        return updateTimeEnd;
    }

    public void setUpdateTimeEnd(String updateTimeEnd) {
        this.updateTimeEnd = updateTimeEnd;
    }

    public Long getBalanceMax() {
        return balanceMax;
    }

    public void setBalanceMax(Long balanceMax) {
        this.balanceMax = balanceMax;
    }

    public Long getBalanceMin() {
        return balanceMin;
    }

    public void setBalanceMin(Long balanceMin) {
        this.balanceMin = balanceMin;
    }

    public Long getPreemptMin() {
        return preemptMin;
    }

    public void setPreemptMin(Long preemptMin) {
        this.preemptMin = preemptMin;
    }

    public Long getPreemptMax() {
        return preemptMax;
    }

    public void setPreemptMax(Long preemptMax) {
        this.preemptMax = preemptMax;
    }

    public Long getAvailableMin() {
        return availableMin;
    }

    public void setAvailableMin(Long availableMin) {
        this.availableMin = availableMin;
    }

    public Long getAvailableMax() {
        return availableMax;
    }

    public void setAvailableMax(Long availableMax) {
        this.availableMax = availableMax;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public Integer getWarehouseSubType() {
        return warehouseSubType;
    }

    public void setWarehouseSubType(Integer warehouseSubType) {
        this.warehouseSubType = warehouseSubType;
    }

    public Integer getCollectionMethod() {
        return collectionMethod;
    }

    public void setCollectionMethod(Integer collectionMethod) {
        this.collectionMethod = collectionMethod;
    }

    public Integer getInventoryShareStatus() {
        return inventoryShareStatus;
    }

    public void setInventoryShareStatus(Integer inventoryShareStatus) {
        this.inventoryShareStatus = inventoryShareStatus;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }
}
