/*
 * @(#)InventoryException.java 1.0 2018-08-30
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 仓库经纬度距离查询请求DTO
 */
@ApiModel(value = "WarehouseCoordinateQueryReqDto", description = "仓库经纬度距离查询请求DTO")
public class WarehouseCoordinateQueryReqDto extends BaseVo {

    @ApiModelProperty(name = "longitude", value = "当前位置经度")
    private BigDecimal longitude;

    @ApiModelProperty(name = "latitude", value = "当前位置纬度")
    private BigDecimal latitude;

    @ApiModelProperty(name = "warehouseIds", value = "指定仓库id集合")
    private List<Long> warehouseIds;

    @ApiModelProperty(name = "pageNum", value = "当前页数")
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页大小")
    private Integer pageSize;

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public List<Long> getWarehouseIds() {
        return warehouseIds;
    }

    public void setWarehouseIds(List<Long> warehouseIds) {
        this.warehouseIds = warehouseIds;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}