/*
 * @(#)InventoryException.java 1.0 2018-08-30
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 仓库查询Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "WarehouseQueryReqDto", description = "仓库查询Dto")
public class WarehouseQueryReqDto extends RequestDto {

    /**
     * 主键ID
     */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;

    /**
     * 父级物理仓Id（逻辑仓对应的父级物理仓）
     */
    @ApiModelProperty(name = "parentId", value = "父级物理仓Id（逻辑仓对应的父级物理仓）")
    private Long parentId;

    /**
     * 业务形态：0 零售，1 大货，2 全部
     */
    @ApiModelProperty(name = "businessForm", value = "业务形态：0 零售，1 大货，2 全部")
    private Integer businessForm;

    /**
     * 是否主仓：0否1是
     */
    @ApiModelProperty(name = "mainWarehouse", value = "是否主仓：0否1是")
    private Integer mainWarehouse;

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "code", value = "仓库编码")
    private String code;

    @ApiModelProperty(name = "codes", value = "仓库编码集合")
    private List<String> codes;

    @ApiModelProperty(name = "ids", value = "仓库ID集合")
    private List<Long> ids;

    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "name", value = "仓库名称")
    private String name;

    @ApiModelProperty(name = "type", value = "0 物理仓、1 逻辑仓、2 共享仓、3 渠道仓")
    private String type;

    @ApiModelProperty(name = "subType", value = "仓库子类型: 物理仓：0 总仓、1 区域仓、2 第三方仓、3 门店仓（实际库存）\n" +
            "    逻辑仓：4 电商仓、5 经销商仓、6 门店仓（出入库）\n" +
            "    共享仓：7 平台电商共享仓、8 自营电商仓\n" +
            "    渠道仓：9 自营小程序仓、10 第三方小程序仓、11 OMS")
    private Integer subType;

    @ApiModelProperty(name = "types", value = "多仓库类型：GENERAL-总仓 SEPERATE-分仓 WHOLE-全局仓库 STORE-门店仓库 ECOMMERCE-电商仓")
    private List<String> types;

    /**
     * 仓库状态：NORMAL-正常 BANNED-封禁 CORRECTION-整改 ABANDON-废弃
     */
    @ApiModelProperty(name = "status", value = "仓库状态：NORMAL-正常 BANNED-封禁 CORRECTION-整改 ABANDON-废弃")
    private String status;

    /**
     * 路由状态：NORMAL 正常、BANNED 禁用
     */
    @ApiModelProperty(name = "routeStatus", value = "NORMAL-正常、BANNED-禁用")
    private String routeStatus;

    /**
     * 省编码
     */
    @ApiModelProperty(name = "provCode", value = "省编码")
    private String provCode;

    /**
     * 市编码
     */
    @ApiModelProperty(name = "cityCode", value = "市编码")
    private String cityCode;

    /**
     * 区编码
     */
    @ApiModelProperty(name = "areaCode", value = "区编码")
    private String areaCode;

    /**
     * 详细地址
     */
    @ApiModelProperty(name = "addr", value = "详细地址")
    private String addr;

    /**
     * 分组ID
     */
    @ApiModelProperty(name = "groupId", value = "分组ID")
    private Long groupId;

    @ApiModelProperty(name = "updateTimeStart", value = "更新开始日期")
    private String updateTimeStart;

    @ApiModelProperty(name = "updateTimeEnd", value = "更新结束日期")
    private String updateTimeEnd;

    @ApiModelProperty(name = "expressDeliveryStatus", value = "启用快递配送: 1 启用 0 未启用")
    private Boolean expressDeliveryStatus;

    @ApiModelProperty(name = "cityDeliveryStatus", value = "启用同城配送: 1 启用 0 未启用")
    private Boolean cityDeliveryStatus;

    @ApiModelProperty(name = "filterSql", value = "过滤条件")
    private String filterSql;

    @ApiModelProperty(name = "organizationIds", value = "组织ID集合")
    private List<Long> organizationIds;

    public List<Long> getOrganizationIds() {
        return organizationIds;
    }

    public void setOrganizationIds(List<Long> organizationIds) {
        this.organizationIds = organizationIds;
    }

    public Boolean getExpressDeliveryStatus() {
        return expressDeliveryStatus;
    }

    public void setExpressDeliveryStatus(Boolean expressDeliveryStatus) {
        this.expressDeliveryStatus = expressDeliveryStatus;
    }

    public Boolean getCityDeliveryStatus() {
        return cityDeliveryStatus;
    }

    public void setCityDeliveryStatus(Boolean cityDeliveryStatus) {
        this.cityDeliveryStatus = cityDeliveryStatus;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 设置仓库编码
     */
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 获取仓库编码
     */
    public String getCode() {
        return this.code;
    }

    /**
     * 设置仓库名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取仓库名称
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置仓库类型：1 总仓 2 分仓 3 门店仓
     */
    public void setType(String type) {
        this.type = type;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    /**
     * 获取仓库类型：1 总仓 2 分仓 3 门店仓
     */
    public String getType() {
        return this.type;
    }

    /**
     * 设置省编码
     */
    public void setProvCode(String provCode) {
        this.provCode = provCode;
    }

    /**
     * 获取省编码
     */
    public String getProvCode() {
        return this.provCode;
    }

    /**
     * 设置市编码
     */
    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    /**
     * 获取市编码
     */
    public String getCityCode() {
        return this.cityCode;
    }

    /**
     * 设置区编码
     */
    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    /**
     * 获取区编码
     */
    public String getAreaCode() {
        return this.areaCode;
    }

    /**
     * 设置详细地址
     */
    public void setAddr(String addr) {
        this.addr = addr;
    }

    /**
     * 获取详细地址
     */
    public String getAddr() {
        return this.addr;
    }

    /**
     * 设置分组ID
     */
    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    /**
     * 获取分组ID
     */
    public Long getGroupId() {
        return this.groupId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getUpdateTimeStart() {
        return updateTimeStart;
    }

    public void setUpdateTimeStart(String updateTimeStart) {
        this.updateTimeStart = updateTimeStart;
    }

    public String getUpdateTimeEnd() {
        return updateTimeEnd;
    }

    public void setUpdateTimeEnd(String updateTimeEnd) {
        this.updateTimeEnd = updateTimeEnd;
    }

    public String getRouteStatus() {
        return routeStatus;
    }

    public void setRouteStatus(String routeStatus) {
        this.routeStatus = routeStatus;
    }

    public List<String> getTypes() {
        return types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public List<String> getCodes() {
        return codes;
    }

    public void setCodes(List<String> codes) {
        this.codes = codes;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Integer getBusinessForm() {
        return businessForm;
    }

    public void setBusinessForm(Integer businessForm) {
        this.businessForm = businessForm;
    }

    public Integer getMainWarehouse() {
        return mainWarehouse;
    }

    public void setMainWarehouse(Integer mainWarehouse) {
        this.mainWarehouse = mainWarehouse;
    }

    public String getFilterSql() {
        return filterSql;
    }

    public void setFilterSql(String filterSql) {
        this.filterSql = filterSql;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }
}