/*
 * @(#)InventoryException.java 1.0 2018-08-30
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.AreaDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 仓库信息修改Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "WarehouseUpdateReqDto", description = "仓库信息修改Dto")
public class WarehouseUpdateReqDto extends BaseVo {

    @ApiModelProperty(value = "仓库ID", required = true)
    @NotNull(message = "仓库Id不能为空")
    private Long id;

    /**
     * 父级物理仓Id（逻辑仓对应的父级物理仓）
     */
    @ApiModelProperty(name = "parentId", value = "父级物理仓Id（逻辑仓对应的父级物理仓）")
    private Long parentId;

    /**
     * 所属渠道,逗号隔开
     */
    @ApiModelProperty(name = "channelIds", value = "所属渠道,逗号隔开")
    private String channelIds;

    /**
     * 业务形态：0 零售，1 大货，2 全部
     */
    @ApiModelProperty(name = "businessForm", value = "业务形态：0 零售，1 大货，2 全部")
    private Integer businessForm;

    /**
     * 是否主仓：0否1是
     */
    @ApiModelProperty(name = "mainWarehouse", value = "是否主仓：0否1是")
    private Integer mainWarehouse;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "code", value = "仓库编码", required = true)
    @NotNull(message = "仓库code不能为空")
    private String code;

    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "name", value = "仓库名称", required = true)
    @NotNull(message = "仓库name不能为空")
    private String name;

    @NotNull(message = "仓库类型不能为空")
    @ApiModelProperty(name = "type", value = "0 物理仓、1 逻辑仓、2 共享仓、3 渠道仓")
    private String type;

    @ApiModelProperty(name = "subType", value = "仓库子类型: 物理仓：0 总仓、1 区域仓、2 第三方仓、3 门店仓（实际库存）\n" +
            "    逻辑仓：4 电商仓、5 经销商仓、6 门店仓（出入库）\n" +
            "    共享仓：7 平台电商共享仓、8 自营电商仓\n" +
            "    渠道仓：9 自营小程序仓、10 第三方小程序仓、11 OMS")
    private Integer subType;

    /**
     * 路由状态
     */
    @ApiModelProperty(name = "routeStatus", value = "路由状态")
    private String routeStatus;

    @ApiModelProperty(name = "inventoryShareStatus", value = "库存共享状态：false 不开启(默认), true 开启")
    private Boolean inventoryShareStatus;

    /**
     * 库存共享类型：0单组织，1全局
     */
    @ApiModelProperty(name = "inventoryShareType", value = "库存共享类型：0单组织，1全局")
    private Integer inventoryShareType;

    /**
     * 仓库状态
     */
    @ApiModelProperty(name = "status", value = "仓库状态")
    private String status;

    /**
     * 省编码
     */
    @ApiModelProperty(name = "provCode", value = "省编码")
//    @NotNull(message = "省编码不能为空")
    private String provCode;

    /**
     * 市编码
     */
    @ApiModelProperty(name = "cityCode", value = "市编码")
//    @NotNull(message = "市编码不能为空")
    private String cityCode;

    /**
     * 区编码
     */
    @ApiModelProperty(name = "areaCode", value = "区编码")
//    @NotNull(message = "区编码不能为空")
    private String areaCode;

    /**
     * 详细地址
     */
    @ApiModelProperty(name = "addr", value = "详细地址")
//    @NotNull(message = "详细地址不能为空")
    private String addr;

    /**
     * 分组ID
     */
    @ApiModelProperty(name = "groupId", value = "分组ID")
    private Long groupId;

    /**
     * 品牌范围
     */
    @ApiModelProperty(name = "brandCode", value = "品牌code", required = true)
    private String brandCode;

    @ApiModelProperty(name = "brandName", value = "品牌名称", required = true)
    private String brandName;

    /**
     * 仓库地址的经纬度坐标
     */
//    @NotNull(message = "仓库地址坐标不能为空")
    @ApiModelProperty(name = "coordinates", value = "仓库地址的经纬度坐标", required = true)
    private String coordinates;

    /**
     * 备注信息
     */
    @ApiModelProperty(name = "remark", value = "备注信息")
    private String remark;

    /**
     * 所属组织code
     */
    @ApiModelProperty(name = "organizationId", value = "所属组织Id")
    private Long organizationId;

    /**
     * 所属组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "所属组织名称")
    private String organizationName;

    /**
     * 负责人名字
     */
    @ApiModelProperty(name = "contactPerson", value = "负责人名字")
    private String contactPerson;

    /**
     * 联系方式
     */
    @ApiModelProperty(name = "contactPhone", value = "联系方式")
    private String contactPhone;

    /**
     * 发货阈值
     */
    @ApiModelProperty(name = "deliverThresholdValue", value = "发货阈值")
    private Integer deliverThresholdValue;

    @ApiModelProperty(name = "creditValue", value = "信用值")
    private Integer creditValue;

    @ApiModelProperty(name = "deliverTimeLimit", value = "发货时效")
    private Integer deliverTimeLimit;

    @ApiModelProperty(name = "deliveryPartyType", value = " 配送方类型： 1 商家配送 2 第三方配送")
    private Integer deliveryPartyType;

    @ApiModelProperty(name = "warehouseDeliveryDtoList", value = "仓库配送方信息")
    private List<WarehouseDeliveryDto> warehouseDeliveryDtoList;

    /**
     * 同城配送启用状态：1 启用 0 不启用
     */
    @ApiModelProperty(name = "cityDeliveryStatus", value = " 同城配送启用状态：true 启用 false 不启用")
    private Boolean cityDeliveryStatus;


    /**
     * 地理围栏信息
     */
    @ApiModelProperty(name = "geoFence", value = "地理围栏信息")
    private String geoFence;

    /**
     * 快递配送启用状态： 1 启用 0 不启用
     */
    @ApiModelProperty(name = "expressDeliveryStatus", value = " 快递启用状态： true 启用 false 不启用")
    private Boolean expressDeliveryStatus;

    /**
     * 快递配送区域
     */
    @ApiModelProperty(name = "serviceAreaList", value = "快递配送区域")
    private List<AreaDto> serviceAreaList;

    public Integer getDeliveryPartyType() {
        return deliveryPartyType;
    }

    public void setDeliveryPartyType(Integer deliveryPartyType) {
        this.deliveryPartyType = deliveryPartyType;
    }

    public Integer getCreditValue() {
        return creditValue;
    }

    public void setCreditValue(Integer creditValue) {
        this.creditValue = creditValue;
    }

    public Integer getDeliverTimeLimit() {
        return deliverTimeLimit;
    }

    public void setDeliverTimeLimit(Integer deliverTimeLimit) {
        this.deliverTimeLimit = deliverTimeLimit;
    }

    public List<WarehouseDeliveryDto> getWarehouseDeliveryDtoList() {
        return warehouseDeliveryDtoList;
    }

    public void setWarehouseDeliveryDtoList(List<WarehouseDeliveryDto> warehouseDeliveryDtoList) {
        this.warehouseDeliveryDtoList = warehouseDeliveryDtoList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 设置应用实例ID
     */
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * 获取应用实例ID
     */
    public Long getInstanceId() {
        return this.instanceId;
    }

    /**
     * 设置租户id
     */
    public Long getTenantId() {
        return tenantId;
    }

    /**
     * 获取租户id
     */
    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 设置仓库名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取仓库名称
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置省编码
     */
    public void setProvCode(String provCode) {
        this.provCode = provCode;
    }

    /**
     * 获取省编码
     */
    public String getProvCode() {
        return this.provCode;
    }

    /**
     * 设置市编码
     */
    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    /**
     * 获取市编码
     */
    public String getCityCode() {
        return this.cityCode;
    }

    /**
     * 设置区编码
     */
    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    /**
     * 获取区编码
     */
    public String getAreaCode() {
        return this.areaCode;
    }

    /**
     * 设置详细地址
     */
    public void setAddr(String addr) {
        this.addr = addr;
    }

    /**
     * 获取详细地址
     */
    public String getAddr() {
        return this.addr;
    }

    /**
     * 设置分组ID
     */
    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    /**
     * 获取分组ID
     */
    public Long getGroupId() {
        return this.groupId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getRouteStatus() {
        return routeStatus;
    }

    public void setRouteStatus(String routeStatus) {
        this.routeStatus = routeStatus;
    }

    public Boolean getInventoryShareStatus() {
        return inventoryShareStatus;
    }

    public void setInventoryShareStatus(Boolean inventoryShareStatus) {
        this.inventoryShareStatus = inventoryShareStatus;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getCoordinates() {
        return coordinates;
    }

    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getContactPerson() {
        return contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public Integer getDeliverThresholdValue() {
        return deliverThresholdValue;
    }

    public void setDeliverThresholdValue(Integer deliverThresholdValue) {
        this.deliverThresholdValue = deliverThresholdValue;
    }

    public String getGeoFence() {
        return geoFence;
    }

    public void setGeoFence(String geoFence) {
        this.geoFence = geoFence;
    }

    public List<AreaDto> getServiceAreaList() {
        return serviceAreaList;
    }

    public void setServiceAreaList(List<AreaDto> serviceAreaList) {
        this.serviceAreaList = serviceAreaList;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public Boolean getCityDeliveryStatus() {
        return cityDeliveryStatus;
    }

    public void setCityDeliveryStatus(Boolean cityDeliveryStatus) {
        this.cityDeliveryStatus = cityDeliveryStatus;
    }

    public Boolean getExpressDeliveryStatus() {
        return expressDeliveryStatus;
    }

    public void setExpressDeliveryStatus(Boolean expressDeliveryStatus) {
        this.expressDeliveryStatus = expressDeliveryStatus;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Integer getBusinessForm() {
        return businessForm;
    }

    public void setBusinessForm(Integer businessForm) {
        this.businessForm = businessForm;
    }

    public Integer getMainWarehouse() {
        return mainWarehouse;
    }

    public void setMainWarehouse(Integer mainWarehouse) {
        this.mainWarehouse = mainWarehouse;
    }

    public String getChannelIds() {
        return channelIds;
    }

    public void setChannelIds(String channelIds) {
        this.channelIds = channelIds;
    }

    public Integer getInventoryShareType() {
        return inventoryShareType;
    }

    public void setInventoryShareType(Integer inventoryShareType) {
        this.inventoryShareType = inventoryShareType;
    }
}