package com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

/**
 * DiffOrderQueryReqDto对象
 *
 * @author qiuzhi
 * @since 2021-05-24
 */
@ApiModel(value = "DiffOrderReqDto", description = "DiffOrder查询请求对象")
public class DiffOrderQueryReqDto extends RequestDto {

    /**
     * 分组ID
     */
    @ApiModelProperty("ID")
    private Long id;
    /**
     * 来源单号(调拨入库单)
     */
    @ApiModelProperty(value = "来源单号(调拨入库单)")
    private Long orderSrcId;


    @ApiModelProperty(value = "发货物理仓ID")
    private Long outPhysicalWarehouseId;

    /**
     * 收货物理仓ID
     */
    @ApiModelProperty(value = "收货物理仓ID")
    private Long inPhysicalWarehouseId;

    /**
     * 发货逻辑仓ID
     */
    @ApiModelProperty(value = "发货逻辑仓ID")
    private Long outLogicWarehouseId;

    /**
     * 收货逻辑仓ID
     */
    @ApiModelProperty(value = "收货逻辑仓ID")
    private Long inLogicWarehouseId;

    @ApiModelProperty(value = "创建时间开始")
    private String createTimeStart;

    @ApiModelProperty(value = "创建时间结束")
    private String createTimeEnd;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOrderSrcId() {
        return orderSrcId;
    }

    public void setOrderSrcId(Long orderSrcId) {
        this.orderSrcId = orderSrcId;
    }

    public Long getOutPhysicalWarehouseId() {
        return outPhysicalWarehouseId;
    }

    public void setOutPhysicalWarehouseId(Long outPhysicalWarehouseId) {
        this.outPhysicalWarehouseId = outPhysicalWarehouseId;
    }

    public Long getInPhysicalWarehouseId() {
        return inPhysicalWarehouseId;
    }

    public void setInPhysicalWarehouseId(Long inPhysicalWarehouseId) {
        this.inPhysicalWarehouseId = inPhysicalWarehouseId;
    }

    public Long getOutLogicWarehouseId() {
        return outLogicWarehouseId;
    }

    public void setOutLogicWarehouseId(Long outLogicWarehouseId) {
        this.outLogicWarehouseId = outLogicWarehouseId;
    }

    public Long getInLogicWarehouseId() {
        return inLogicWarehouseId;
    }

    public void setInLogicWarehouseId(Long inLogicWarehouseId) {
        this.inLogicWarehouseId = inLogicWarehouseId;
    }

    public String getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(String createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public String getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(String createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }
}
