package com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.AddressReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * TransferOrderAddReqDto对象
 *
 * @author qiuzhi
 * @since 2021-05-21
 */
@ApiModel(value = "TransferOrderAddReqDto", description = "TransferOrder添加请求对象")
public class TransferOrderAddReqDto extends RequestDto {

    /**
     * 业务单号
     */
    @ApiModelProperty(value = "业务单号")
    private String orderNo;

    /**
     * 来源单号
     */
    @ApiModelProperty(value = "来源单号")
    private String sourceCode;

    /**
     * 发货物理仓ID
     */
    @ApiModelProperty(value = "发货物理仓ID")
    private Long outPhysicalWarehouseId;

    /**
     * 收货物理仓ID
     */
    @ApiModelProperty(value = "收货物理仓ID")
    private Long inPhysicalWarehouseId;

    /**
     * 发货逻辑仓ID
     */
    @ApiModelProperty(value = "发货逻辑仓ID")
    private Long outLogicWarehouseId;

    /**
     * 收货逻辑仓ID
     */
    @ApiModelProperty(value = "收货逻辑仓ID")
    private Long inLogicWarehouseId;

    /**
     * 出库单ID
     */
    @ApiModelProperty(value = "出库单ID")
    private Long outStorageId;

    /**
     * 入库单ID
     */
    @ApiModelProperty(value = "入库单ID")
    private Long inStorageId;

    /**
     * 状态:1待提交,2待审核,3审核不通过,4待执行,5执行中,6已完成,7已取消
     */
    @ApiModelProperty(value = "状态:1待提交,2待审核,3审核不通过,4待执行,5执行中,6已完成,7已取消")
    private Integer status;

    /**
     * 类型:1物理仓调拨,2虚拟仓调拨
     */
    @ApiModelProperty(value = "类型:1物理仓调拨,2虚拟仓调拨")
    private Integer type;

    @ApiModelProperty(value = "货品列表")
    private List<TransferOrderDetailAddReqDto> transferOrderDetails;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 审核说明
     */
    @ApiModelProperty(value = "审核说明")
    private String auditDesc;

    /**
     * 收发差异单ID
     */
    @ApiModelProperty(value = "收发差异单ID")
    private Long diffOrderId;

    /**
     * 审核时间
     */
    @ApiModelProperty(name = "审核时间")
    private Date auditTime;

    /**
     * 审核人
     */
    @ApiModelProperty(name = "审核人")
    private String auditPerson;


    @ApiModelProperty(value = "收货人地址")
    private AddressReqDto addressReqDto;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public Long getOutPhysicalWarehouseId() {
        return outPhysicalWarehouseId;
    }

    public void setOutPhysicalWarehouseId(Long outPhysicalWarehouseId) {
        this.outPhysicalWarehouseId = outPhysicalWarehouseId;
    }

    public Long getInPhysicalWarehouseId() {
        return inPhysicalWarehouseId;
    }

    public void setInPhysicalWarehouseId(Long inPhysicalWarehouseId) {
        this.inPhysicalWarehouseId = inPhysicalWarehouseId;
    }

    public Long getOutLogicWarehouseId() {
        return outLogicWarehouseId;
    }

    public void setOutLogicWarehouseId(Long outLogicWarehouseId) {
        this.outLogicWarehouseId = outLogicWarehouseId;
    }

    public Long getInLogicWarehouseId() {
        return inLogicWarehouseId;
    }

    public void setInLogicWarehouseId(Long inLogicWarehouseId) {
        this.inLogicWarehouseId = inLogicWarehouseId;
    }

    public Long getOutStorageId() {
        return outStorageId;
    }

    public void setOutStorageId(Long outStorageId) {
        this.outStorageId = outStorageId;
    }

    public Long getInStorageId() {
        return inStorageId;
    }

    public void setInStorageId(Long inStorageId) {
        this.inStorageId = inStorageId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public List<TransferOrderDetailAddReqDto> getTransferOrderDetails() {
        return transferOrderDetails;
    }

    public void setTransferOrderDetails(List<TransferOrderDetailAddReqDto> transferOrderDetails) {
        this.transferOrderDetails = transferOrderDetails;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAuditDesc() {
        return auditDesc;
    }

    public void setAuditDesc(String auditDesc) {
        this.auditDesc = auditDesc;
    }

    public Long getDiffOrderId() {
        return diffOrderId;
    }

    public void setDiffOrderId(Long diffOrderId) {
        this.diffOrderId = diffOrderId;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public String getAuditPerson() {
        return auditPerson;
    }

    public void setAuditPerson(String auditPerson) {
        this.auditPerson = auditPerson;
    }

    public AddressReqDto getAddressReqDto() {
        return addressReqDto;
    }

    public void setAddressReqDto(AddressReqDto addressReqDto) {
        this.addressReqDto = addressReqDto;
    }
}
