package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 库存单据Dto对象
 */
@ApiModel(value = "BillDto", description = "BillDto对象")
public class BillRespDto extends RequestDto {

    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = " 仓库名称  ", allowEmptyValue = true)
    private String warehouseName;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     *
     */
    @ApiModelProperty(name = "id", value = "   ", allowEmptyValue = true)
    private Long id;

    /**
     * 仓库ID
     */
    @ApiModelProperty(name = "warehouseId", value = " 仓库ID  ", allowEmptyValue = true)
    private Long warehouseId;

    /**
     * 单据id
     */
    @ApiModelProperty(name = "billSrcId", value = " 单据id  ", allowEmptyValue = true)
    private Long billSrcId;

    /**
     * 单据来源
     */
    @ApiModelProperty(name = "billSrc", value = " 单据来源  ", allowEmptyValue = true)
    private String billSrc;

    /**
     * 单据编码
     */
    @ApiModelProperty(name = "billNo", value = " 单据编码  ", allowEmptyValue = true)
    private String billNo;

    /**
     * 业务单号
     */
    @ApiModelProperty(name = "businessId", value = " 业务单号  ", allowEmptyValue = true)
    private Long businessId;

    /**
     * 1：待提交、2：待审核:3：待出库、4：待入库，5：审核不通过、6：待发货、7：已完结、8：取消
     */
    @ApiModelProperty(name = "status", value = " 1：待提交、2：待审核:3：待出库、4：待入库，5：审核不通过、6：待发货、7：已完结、8：取消  ", allowEmptyValue = true)
    private Integer status;

    /**
     * 1：预留，2：处置
     */
    @ApiModelProperty(name = "category", value = " 1：预留，2：处置  ", allowEmptyValue = true)
    private String category;

    /**
     * 0：普通，1：报废，2：领用
     */
    @ApiModelProperty(name = "type", value = " 0：普通，1：报废，2：领用  ", allowEmptyValue = true)
    private Integer type;

    /**
     * 审核人
     */
    @ApiModelProperty(name = "auditPerson", value = " 审核人  ", allowEmptyValue = true)
    private String auditPerson;

    /**
     * 审核时间
     */
    @ApiModelProperty(name = "auditTime", value = " 审核时间  ", allowEmptyValue = true)
    private Date auditTime;

    /**
     * 创建人
     */
    @ApiModelProperty(name = "createPerson", value = " 创建人  ", allowEmptyValue = true)
    private String createPerson;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = " 创建时间  ", allowEmptyValue = true)
    private Date createTime;

    /**
     * 修改人
     */
    @ApiModelProperty(name = "updatePerson", value = " 修改人  ", allowEmptyValue = true)
    private String updatePerson;

    /**
     * 最近一次修改时间
     */
    @ApiModelProperty(name = "updateTime", value = " 最近一次修改时间  ", allowEmptyValue = true)
    private Date updateTime;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public Long getWarehouseId() {
        return this.warehouseId;
    }

    public void setBillSrcId(Long billSrcId) {
        this.billSrcId = billSrcId;
    }

    public Long getBillSrcId() {
        return this.billSrcId;
    }

    public void setBillSrc(String billSrc) {
        this.billSrc = billSrc;
    }

    public String getBillSrc() {
        return this.billSrc;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    public Long getBusinessId() {
        return this.businessId;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return this.type;
    }

    public void setAuditPerson(String auditPerson) {
        this.auditPerson = auditPerson;
    }

    public String getAuditPerson() {
        return this.auditPerson;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Date getAuditTime() {
        return this.auditTime;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public String getCreatePerson() {
        return this.createPerson;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public String getUpdatePerson() {
        return this.updatePerson;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}