/*
 * CargoRespDto.class 1.0 2018-08-31
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 货品接口返回Dto
 *
 * @author 纳兰
 * @since 2.0.0
 */
@ApiModel(value = "CargoRespDto", description = "货品接口返回Dto")
public class CargoRespDto extends BaseVo {
    private Long id;
    /**
     * 分组ID
     */
    @ApiModelProperty(name = "groupId", value = "分组ID")
    private Long groupId;
    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    /**
     * 编码
     */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    @ApiModelProperty(name = "name", value = "货品名称")
    private String name;

    /**
     * 单位
     */
    @ApiModelProperty(name = "unit", value = "单位")
    private String unit;

    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "brandCode", value = "品牌编码")
    private String brandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "brandName", value = "品牌名称")
    private String brandName;

    /**
     * 产地
     */
    @ApiModelProperty(name = "placeOfOrigin", value = "产地")
    private String placeOfOrigin;


    /**
     * 预警库存数
     */
    @ApiModelProperty(name = "warningInventory", value = "预警库存数")
    private BigDecimal warningInventory;


    /**
     * 线下安全库存
     */
    @ApiModelProperty(name = "offlineSafetyStock", value = "线下安全库存")
    private BigDecimal offlineSafetyStock;

    /**
     * 线下是否可售
     */
    @ApiModelProperty(name = "ifAvailableOffline", value = "线下是否可售，0-不可售，1-可售")
    private Integer ifAvailableOffline;

    /**
     * 安全库存策略，0-关闭，1-开启
     */
    @ApiModelProperty(name = "safetyStockStrategy", value = "安全库存策略，0-开启，1-关闭")
    private Integer safetyStockStrategy;

    /**
     * 防超卖库存数
     */
    @ApiModelProperty(name = "avoidOversoldInventory", value = "防超卖库存数")
    private BigDecimal avoidOversoldInventory;

    /**
     * 单渠道共享数
     */
    @ApiModelProperty(name = "singleChannelShare", value = "单渠道共享数")
    private BigDecimal singleChannelShare;

    /**
     * 库存检查配置
     */
    @ApiModelProperty(name = "checkConfigId", value = "库存检查配置")
    private Long checkConfigId;

    /**
     * 拆包配置
     */
    @ApiModelProperty(name = "packageSplitId", value = "拆包配置")
    private Long packageSplitId;

    /**
     * 重量
     */
    @ApiModelProperty(name = "quantity", value = "重量")
    private BigDecimal quantity;

    /**
     * 重量单位，单位可选mg/g/kg/t（毫克/克/千克/吨），默认kg
     */
    @ApiModelProperty(name = "quantityUnit", value = "重量单位，单位可选mg/g/kg/t（毫克/克/千克/吨），默认kg")
    private String quantityUnit;

    /**
     * 体积
     */
    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;

    /**
     * 货品货号
     */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;

    /**
     * 货品条码
     */
    @ApiModelProperty(name = "barCode", value = "货品条码")
    private String barCode;

    /**
     * 长
     */
    @ApiModelProperty(name = "length", value = "长")
    private Integer length;

    /**
     * 宽
     */
    @ApiModelProperty(name = "width", value = "宽")
    private Integer width;

    /**
     * 高
     */
    @ApiModelProperty(name = "height", value = "高")
    private Integer height;

    /**
     * 长单位
     */
    @ApiModelProperty(name = "lengthUnit", value = "长单位,单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String lengthUnit;

    /**
     * 宽单位
     */
    @ApiModelProperty(name = "widthUnit", value = "宽单位,单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String widthUnit;

    /**
     * 高单位
     */
    @ApiModelProperty(name = "heightUnit", value = "高单位,单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String heightUnit;

    /**
     * 所属客户编码
     */
    @ApiModelProperty(name = "customerNo", value = "所属客户编码")
    private String customerNo;

    /**
     * 所属客户名称
     */
    @ApiModelProperty(name = "customerName", value = "所属客户名称")
    private String customerName;

    /**
     * 货品详情
     */
    @ApiModelProperty(name = "detail", value = "货品详情")
    private String detail;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;

    @ApiModelProperty(name = "updateTime", value = "更新时间")
    private Date updateTime;

    /**
     * 增值税率
     */
    @ApiModelProperty(name = "taxRate", value = "增值税率")
    private Integer taxRate;

    /**
     * 毛重
     */
    @ApiModelProperty(name = "grossWeight", value = "毛重")
    private BigDecimal grossWeight;

    /**
     * 毛重单位
     */
    @ApiModelProperty(name = "grossWeightUnit", value = "毛重单位")
    private String grossWeightUnit;

    /**
     * 净重
     */
    @ApiModelProperty(name = "netWeight", value = "净重")
    private BigDecimal netWeight;

    /**
     * 净重单位
     */
    @ApiModelProperty(name = "netWeightUnit", value = "净重单位")
    private String netWeightUnit;

    public Integer getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Integer taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getGrossWeight() {
        return grossWeight;
    }

    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }

    public String getGrossWeightUnit() {
        return grossWeightUnit;
    }

    public void setGrossWeightUnit(String grossWeightUnit) {
        this.grossWeightUnit = grossWeightUnit;
    }

    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public String getNetWeightUnit() {
        return netWeightUnit;
    }

    public void setNetWeightUnit(String netWeightUnit) {
        this.netWeightUnit = netWeightUnit;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Long getCheckConfigId() {
        return checkConfigId;
    }

    public void setCheckConfigId(Long checkConfigId) {
        this.checkConfigId = checkConfigId;
    }

    public Long getPackageSplitId() {
        return packageSplitId;
    }

    public void setPackageSplitId(Long packageSplitId) {
        this.packageSplitId = packageSplitId;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }


    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public Integer getLength() {
        return length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public String getLengthUnit() {
        return lengthUnit;
    }

    public void setLengthUnit(String lengthUnit) {
        this.lengthUnit = lengthUnit;
    }

    public String getWidthUnit() {
        return widthUnit;
    }

    public void setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
    }

    public String getHeightUnit() {
        return heightUnit;
    }

    public void setHeightUnit(String heightUnit) {
        this.heightUnit = heightUnit;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getQuantityUnit() {
        return quantityUnit;
    }

    public void setQuantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getPlaceOfOrigin() {
        return placeOfOrigin;
    }

    public void setPlaceOfOrigin(String placeOfOrigin) {
        this.placeOfOrigin = placeOfOrigin;
    }

    public BigDecimal getOfflineSafetyStock() {
        return offlineSafetyStock;
    }

    public void setOfflineSafetyStock(BigDecimal offlineSafetyStock) {
        this.offlineSafetyStock = offlineSafetyStock;
    }

    public Integer getIfAvailableOffline() {
        return ifAvailableOffline;
    }

    public void setIfAvailableOffline(Integer ifAvailableOffline) {
        this.ifAvailableOffline = ifAvailableOffline;
    }

    public Integer getSafetyStockStrategy() {
        return safetyStockStrategy;
    }

    public void setSafetyStockStrategy(Integer safetyStockStrategy) {
        this.safetyStockStrategy = safetyStockStrategy;
    }

    public BigDecimal getAvoidOversoldInventory() {
        return avoidOversoldInventory;
    }

    public void setAvoidOversoldInventory(BigDecimal avoidOversoldInventory) {
        this.avoidOversoldInventory = avoidOversoldInventory;
    }

    public BigDecimal getSingleChannelShare() {
        return singleChannelShare;
    }

    public void setSingleChannelShare(BigDecimal singleChannelShare) {
        this.singleChannelShare = singleChannelShare;
    }


    public BigDecimal getWarningInventory() {
        return warningInventory;
    }

    public void setWarningInventory(BigDecimal warningInventory) {
        this.warningInventory = warningInventory;
    }

}
